package main;

import java.awt.event.KeyEvent;
import java.awt.GraphicsEnvironment;
import java.awt.geom.Point2D;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.awt.geom.Rectangle2D;
import java.awt.geom.Ellipse2D;
import java.awt.MouseInfo;
import java.awt.Shape;
import java.awt.Rectangle;
import java.awt.image.BufferStrategy;
import java.awt.GraphicsConfiguration;
import java.awt.Toolkit;
import java.awt.GraphicsDevice;
import java.awt.geom.Area;
import java.awt.FontMetrics;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.util.HashMap;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.awt.event.KeyListener;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.FileOutputStream;

import collision.Bound;

import gamegui.ScrollBar;
import gamegui.Align;
import gamegui.Member;
import gamegui.Textbox;
import gamegui.Label;
import gamegui.Button;
import gamegui.ScrollList;
import gamegui.Window;

import utils.DynamicImage;
import utils.Utils;
import utils.WrappedString;

public class LostHavenRPG implements KeyListener, MouseListener {
    private static final boolean RUNNING_FROM_JAR = false;
    GameState gameState;
    AuxState auxState;
    Point playerLoc;
    boolean started;
    boolean done;
    boolean showFps;
    boolean bounds;
    boolean passable;
    boolean minimizedGui;
    int frameCount;
    int lastFrameCount;
    int refreshRate;
    long lastFpsUpdate;
    Graphics g;
    HashMap<Integer, Tile> imageMap;
    HashMap<Integer, Creature> crMap;
    static HashMap<String, Item> itemMap;
    Map map;
    Frame frmMain;
    Window wndMain;
    Window wndCreateAccount;
    Window wndLoadGame;
    Window wndCredits;
    Window wndStatDisplay;
    Window wndDiagnostics;
    Window wndCharacter;
    Window wndInventory;
    Window wndQuests;
    boolean showCharacter;
    boolean showInventory;
    boolean showQuests;
    ScrollList lstSavedGames;
    Window wndMessage;
    Button btnMenu;
    Button btnStats;
    Button btnGems;
    Button btnInventory;
    Button btnMap;
    Label lblGemVal;
    Label lblSpellCost;
    ScrollList lstInventory;
    ScrollList lstGems;
    DynamicImage fullGui;
    DynamicImage miniGui;
    DynamicImage hpBar;
    DynamicImage mpBar;
    DynamicImage xpBar;
    DynamicImage titleBg;
    DynamicImage darkBg;
    DynamicImage horBorder;
    DynamicImage fireIcon;
    DynamicImage iceIcon;
    DynamicImage windIcon;
    DynamicImage hpHoverBar;
    DynamicImage gcsLogo;
    DynamicImage dialogBg;
    DynamicImage characterBg;
    DynamicImage questsBg;
    DynamicImage inventoryBg;
    DynamicImage yellowCursor;
    DynamicImage greenCursor;
    DynamicImage redCursor;
    DynamicImage cursor;
    DynamicImage plus;
    DynamicImage darkPlus;
    Textbox selectedText;
    Button selectedButton;
    Font font11;
    Font font12;
    Font font14;
    Font font24;
    Font fontTT;
    Font fontCustom11;
    Font fontCustom12;
    Font fontCustom14;
    Font fontCustom24;
    Font fontCustom30;
    Font guiFont12;
    Font guiFont14;
    Color color1;
    Color color2;
    Player player;
    Enemy cr1;
    NPC npc;
    FontMetrics m;
    Dialog curDialog;
    Item curItem;
    Point offset;
    boolean equipped;
    int equipNum;
    Area fullBorder;
    Area miniBorder;
    Area miniBtn;
    Area miniBtn1;
    Area miniBtn2;
    Area iBtn;
    Area eBtn;
    Area qBtn;
    Area mainBtn;
    Area areaCharacter;
    Area areaInventory;
    Area areaQuests;
    Area equipWeapon;
    Area equipHead;
    Area equipHands;
    Area equipBody;
    Area equipFeet;
    WrappedString descStrength;
    WrappedString descDexterity;
    WrappedString descConstitution;
    WrappedString descIntelligence;
    Color redHaze;
    Color blueHaze;
    Point playerMapLoc;
    
    public LostHavenRPG(final GraphicsDevice device) {
        this.started = false;
        try {
            final GraphicsConfiguration gc = device.getDefaultConfiguration();
            (this.frmMain = new Frame(gc)).setUndecorated(true);
            this.frmMain.setIgnoreRepaint(true);
            device.setFullScreenWindow(this.frmMain);
            if (device.isDisplayChangeSupported()) {
                Utils.chooseBestDisplayMode(device, 800, 600);
            }
            this.frmMain.addMouseListener(this);
            this.frmMain.addKeyListener(this);
            this.frmMain.createBufferStrategy(2);
            final BufferStrategy bufferStrategy = this.frmMain.getBufferStrategy();
            this.g = bufferStrategy.getDrawGraphics();
            this.refreshRate = device.getDisplayMode().getRefreshRate();
            Utils.init(gc, RUNNING_FROM_JAR);
            this.gameState = GameState.Main;
            this.auxState = AuxState.None;
            this.done = false;
            this.showFps = false;
            this.frameCount = 0;
            this.lastFrameCount = 0;
            this.lastFpsUpdate = System.nanoTime();
            this.playerLoc = new Point(400, 300);
            this.selectedText = null;
            this.selectedButton = null;
            this.curItem = null;
            this.redHaze = new Color(255, 0, 0, 100);
            this.blueHaze = new Color(0, 0, 255, 100);
            final boolean showCharacter = false;
            this.showQuests = showCharacter;
            this.showInventory = showCharacter;
            this.showCharacter = showCharacter;
            this.bounds = false;
            this.passable = false;
            this.minimizedGui = false;
            final Toolkit tk = Toolkit.getDefaultToolkit();
            this.frmMain.setCursor(tk.createCustomCursor(tk.createImage(""), new Point(), null));
            this.loadGUI(bufferStrategy);
            this.loadMap();
            this.loadItems();
            this.loadCreatures();
            this.started = true;
            while (!this.done) {
                this.g = bufferStrategy.getDrawGraphics();
                this.handleGameEvents();
                this.render(this.g);
                this.detectMouseOver(this.g);
                if (MouseInfo.getPointerInfo().getLocation() != null) {
                    this.cursor.draw(this.g, MouseInfo.getPointerInfo().getLocation().x - 5, MouseInfo.getPointerInfo().getLocation().y - 2);
                }
                this.g.dispose();
                bufferStrategy.show();
                ++this.frameCount;
                if (System.nanoTime() - 1000000000L >= this.lastFpsUpdate) {
                    this.lastFpsUpdate = System.nanoTime();
                    this.lastFrameCount = this.frameCount;
                    this.frameCount = 0;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            return;
        } finally {
            device.setFullScreenWindow(null);
        }
        device.setFullScreenWindow(null);
    }
    
    private void updateLoadingScreen(final BufferStrategy bufferStrategy) {
        this.g = bufferStrategy.getDrawGraphics();
        this.gcsLogo.draw(this.g, 0, 0);
        this.g.setColor(Color.black);
        this.g.setFont(this.guiFont12);
        this.g.drawString("Loading...", 368, 31);
        this.g.dispose();
        bufferStrategy.show();
    }
    
    private void loadGUI(final BufferStrategy bufferStrategy) {
        this.gcsLogo = new DynamicImage("gui/gcslogo.png");
        this.guiFont12 = new Font("Garamond", 1, 12);
        this.m = this.g.getFontMetrics(this.guiFont12);
        this.updateLoadingScreen(bufferStrategy);

        this.font11 = new Font("Arial", 0, 11);
        this.font12 = new Font("Arial", 0, 12);
        this.font14 = new Font("Arial", 0, 14);
        this.font24 = new Font("Arial", 0, 24);
        this.fontTT = new Font("Courier New", 0, 11);
        this.guiFont14 = new Font("Garamond", 1, 14);
        try {
            final Font fontCustom = Utils.loadFont("images/gui/Last_words.ttf");
            this.fontCustom11 = fontCustom.deriveFont(0, 11.0f);
            this.fontCustom12 = fontCustom.deriveFont(0, 12.0f);
            this.fontCustom14 = fontCustom.deriveFont(0, 14.0f);
            this.fontCustom24 = fontCustom.deriveFont(0, 24.0f);
            this.fontCustom30 = fontCustom.deriveFont(0, 30.0f);
        } catch (Exception e) {
            e.printStackTrace();
        }
        this.yellowCursor = new DynamicImage("gui/cursor.png");
        this.greenCursor = new DynamicImage("gui/cursorgreen.png");
        this.redCursor = new DynamicImage("gui/cursorred.png");
        this.cursor = this.yellowCursor;
        this.fullGui = new DynamicImage("gui/gui_full.png");
        this.miniGui = new DynamicImage("gui/gui_mini.png");
        this.hpBar = new DynamicImage("gui/hpbar.png");
        this.mpBar = new DynamicImage("gui/mpbar.png");
        this.xpBar = new DynamicImage("gui/xpbar2.png");
        this.titleBg = new DynamicImage("gui/titlebg_circle.png");
        this.darkBg = new DynamicImage("gui/darkerscreenbg.png");
        (this.fullBorder = new Area(new Rectangle(0, 478, 291, 121))).add(new Area(new Rectangle(291, 560, 87, 39)));
        (this.miniBorder = new Area(new Rectangle(0, 553, 291, 46))).add(new Area(new Rectangle(291, 560, 87, 39)));
        this.fireIcon = new DynamicImage("gui/fire_icon.png");
        this.iceIcon = new DynamicImage("gui/ice_icon.png");
        this.windIcon = new DynamicImage("gui/wind_icon.png");
        this.miniBtn1 = new Area(new Ellipse2D.Double(135.0, 478.0, 10.0, 10.0));
        this.miniBtn2 = new Area(new Ellipse2D.Double(135.0, 553.0, 10.0, 10.0));
        this.iBtn = new Area(new Ellipse2D.Double(301.0, 581.0, 17.0, 17.0));
        this.eBtn = new Area(new Ellipse2D.Double(327.0, 581.0, 17.0, 17.0));
        this.qBtn = new Area(new Ellipse2D.Double(353.0, 581.0, 17.0, 17.0));
        this.mainBtn = new Area(new Rectangle(293, 563, 81, 15));
        this.hpHoverBar = new DynamicImage("gui/hp_igbarsmall.png");
        Creature.hpBar = this.hpHoverBar;
        this.dialogBg = new DynamicImage("gui/dialoguebg.png");
        this.characterBg = new DynamicImage("gui/window250x360.png");
        this.questsBg = new DynamicImage("gui/window200x250.png");
        this.inventoryBg = this.questsBg;
        this.plus = new DynamicImage("gui/greenplus.png");
        this.darkPlus = new DynamicImage("gui/darkgreenplus.png");
        this.areaCharacter = new Area(new Rectangle(0, 98, 250, 360));
        this.areaQuests = new Area(new Rectangle(600, 0, 250, 300));
        this.areaInventory = new Area(new Rectangle(600, 270, 250, 300));
        this.equipWeapon = new Area(new Rectangle(40, 285, 40, 60));
        this.equipHead = new Area(new Rectangle(105, 275, 40, 40));
        this.equipHands = new Area(new Rectangle(40, 360, 40, 40));
        this.equipBody = new Area(new Rectangle(105, 330, 40, 60));
        this.equipFeet = new Area(new Rectangle(105, 404, 40, 40));
        this.descStrength = new WrappedString("Strength raises the damage you deal per hit", this.m, 163);
        this.descDexterity = new WrappedString("Dexterity raises your attack rate", this.m, 163);
        this.descConstitution = new WrappedString("Constitution raises your hitpoints", this.m, 163);
        this.descIntelligence = new WrappedString("Intelligence raises your manapoints", this.m, 163);
        this.wndMain = new Window("main", 0, 0, 800, 600, true);
        final Button title = new Button("title", 0, 0, 800, 213, Utils.loadImg("gui/title.png"));
        this.wndMain.add(title);
        this.wndMain.background = this.titleBg;
        this.color1 = new Color(80, 80, 80);
        this.color2 = new Color(20, 20, 20);
        FontMetrics metrics = this.g.getFontMetrics(this.fontCustom30);
        this.wndMain.add(new Button("new game", 100, 270, metrics.stringWidth("Enter the world"), metrics.getHeight(), "Enter the world", this.fontCustom30, this.color1, false));
        this.wndMain.add(new Button("load game", 140, 320, metrics.stringWidth("Back so soon?"), metrics.getHeight(), "Back so soon?", this.fontCustom30, this.color1, false));
        this.wndMain.add(new Button("game info", 180, 370, metrics.stringWidth("How do I get there?"), metrics.getHeight(), "How do I get there?", this.fontCustom30, this.color1, false));
        metrics = this.g.getFontMetrics(this.fontCustom24);
        this.wndMain.add(new Button("credits", 15, 565, metrics.stringWidth("Credits"), metrics.getHeight(), "Credits", this.fontCustom24, this.color1, false));
        this.wndMain.add(new Button("quit", 730, 565, metrics.stringWidth("Quit"), metrics.getHeight(), "Quit", this.fontCustom24, this.color1, false));
        this.wndCharacter = new Window("character", 0, 158, 250, 299, false);
        this.wndInventory = new Window("inventory", 600, 270, 199, 249, false);
        this.wndQuests = new Window("quests", 600, 0, 199, 249, false);
        this.wndStatDisplay = new Window("stat display", 0, 550, 799, 49, false);
        this.btnMenu = new Button("main menu", 360, 10, 80, 20, "Main Menu", this.font12);
        this.btnStats = new Button("stats", 600, 5, 80, 16, "Character", this.font12);
        this.btnInventory = new Button("inventory", 700, 5, 80, 16, "Inventory", this.font12);
        this.btnGems = new Button("gems", 600, 29, 80, 16, "Gems", this.font12);
        this.btnMap = new Button("map", 700, 29, 80, 16, "Map", this.font12);
        this.lblGemVal = new Label("gemVal", 515, 5, 67, 20, "Gem Value: 0", this.font12, Align.Right);
        this.lblSpellCost = new Label("spellCost", 515, 24, 67, 20, "Spell Cost: 0", this.font12, Align.Right);
        this.wndStatDisplay.add(this.btnMenu);
        this.wndStatDisplay.add(this.btnStats);
        this.wndStatDisplay.add(this.btnGems);
        this.wndStatDisplay.add(this.btnInventory);
        this.wndStatDisplay.add(this.btnMap);
        this.wndStatDisplay.add(this.lblGemVal);
        this.wndStatDisplay.add(this.lblSpellCost);
        (this.wndLoadGame = new Window("load", 0, 0, 800, 600, true)).add(new Label("title", 250, 15, 300, 20, "Load Game", this.font24));
        (this.lstSavedGames = new ScrollList("saved games", 300, 200, 200, 200, this.font14, this.frmMain.getBufferStrategy().getDrawGraphics().getFontMetrics(this.font14))).addScrollBar(new ScrollBar("scrollsave", 200, 0, 20, 200, 3, false));
        this.wndLoadGame.add(this.lstSavedGames);
        (this.wndCredits = new Window("main", 0, 0, 800, 600, true)).add(new Label("title", 250, 15, 300, 20, "Credits", this.fontCustom24, new Color(20, 20, 20)));
        this.wndCredits.background = this.darkBg;
        this.wndCredits.add(new Label("1", 250, 160, 300, 20, "Dmitry Portnoy", this.guiFont14, new Color(20, 20, 20)));
        this.wndCredits.add(new Label("2", 250, 180, 300, 20, "Team Leader", this.guiFont12, new Color(20, 20, 20)));
        this.wndCredits.add(new Label("3", 250, 195, 300, 20, "Programmer", this.guiFont12, new Color(20, 20, 20)));
        this.wndCredits.add(new Label("4", 250, 235, 300, 20, "Daniel Vu", this.guiFont14, new Color(20, 20, 20)));
        this.wndCredits.add(new Label("5", 250, 255, 300, 20, "Gui and Item Art", this.guiFont12, new Color(20, 20, 20)));
        this.wndCredits.add(new Label("6", 250, 295, 300, 20, "David Huang", this.guiFont14, new Color(20, 20, 20)));
        this.wndCredits.add(new Label("7", 250, 315, 300, 20, "Designer", this.guiFont12, new Color(20, 20, 20)));
        this.wndCredits.add(new Label("4", 250, 355, 300, 20, "Free Art", this.guiFont14, new Color(20, 20, 20)));
        this.wndCredits.add(new Label("5", 250, 375, 300, 20, "Tileset - Danc (lostgarden.com)", this.guiFont12, new Color(20, 20, 20)));
        this.wndCredits.add(new Label("4", 250, 390, 300, 20, "Creatures - Reiner \"Tiles\" Prokein (reinerstileset.4players.de)", this.guiFont12, new Color(20, 20, 20)));
        this.wndCredits.add(new Label("8", 250, 430, 300, 20, "Special thanks to", this.guiFont14, new Color(20, 20, 20)));
        this.wndCredits.add(new Label("9", 250, 450, 300, 20, "The Game Creation Society", this.guiFont12, new Color(20, 20, 20)));
        (this.wndMessage = new Window("message", 290, 135, 220, 160)).add(new Label("label", 20, 15, 180, 12, "none", this.font12));
        this.wndMessage.add(new Button("button", 70, 115, 80, 30, "OK", this.font12));
        this.wndDiagnostics = new Window("diagnostics", 0, 0, 400, 140, true);
    }
    
    private void loadMap() {
        this.imageMap = new HashMap<Integer, Tile>();
        this.crMap = new HashMap<Integer, Creature>();
        for (int x = 0; x < 16; ++x) {
            this.imageMap.put(MapImage.nextKey(), new Tile(new MapImage(new DynamicImage("tiles/ground" + (x + 1) + ".png"), MapType.Ground)));
        }
        for (int x = 0; x < 12; ++x) {
            this.imageMap.put(MapImage.nextKey(), new Tile(new MapImage(new DynamicImage("tiles/cliff" + (x + 1) + ".png"), MapType.Ground)));
        }
        int last = 15;
        this.imageMap.get(last + 1).getImg().setDrawOffset(-40, 0);
        this.imageMap.get(last + 3).getImg().setDrawOffset(-40, 0);
        this.imageMap.get(last + 5).getImg().setDrawOffset(0, -40);
        this.imageMap.get(last + 6).getImg().setDrawOffset(0, -40);
        this.imageMap.get(last + 7).getImg().setDrawOffset(-40, -40);
        this.imageMap.get(last + 8).getImg().setDrawOffset(0, -40);
        this.imageMap.get(last + 9).getImg().setDrawOffset(-40, 0);
        this.imageMap.get(last + 1).getImg().setSortOffset(-18, 0);
        this.imageMap.get(last + 2).getImg().setSortOffset(62, 0);
        this.imageMap.get(last + 3).getImg().setSortOffset(-18, 0);
        this.imageMap.get(last + 4).getImg().setSortOffset(62, 0);
        this.imageMap.get(last + 5).getImg().setSortOffset(0, 32);
        this.imageMap.get(last + 6).getImg().setSortOffset(0, 32);
        this.imageMap.get(last + 7).getImg().setSortOffset(-18, 32);
        this.imageMap.get(last + 8).getImg().setSortOffset(62, 32);
        this.imageMap.get(last + 9).getImg().setSortOffset(-18, 75);
        this.imageMap.get(last + 10).getImg().setSortOffset(62, 75);
        this.imageMap.get(last + 11).getImg().setSortOffset(0, 75);
        this.imageMap.get(last + 12).getImg().setSortOffset(0, 75);
        this.imageMap.get(last + 1).setBound(new Bound(new Rectangle2D.Double(20.0, 0.0, 15.0, 40.0)));
        this.imageMap.get(last + 2).setBound(new Bound(new Rectangle2D.Double(45.0, 0.0, 21.0, 40.0)));
        this.imageMap.get(last + 3).setBound(new Bound(new Rectangle2D.Double(20.0, 0.0, 15.0, 40.0)));
        this.imageMap.get(last + 4).setBound(new Bound(new Rectangle2D.Double(45.0, 0.0, 21.0, 40.0)));
        this.imageMap.get(last + 5).setBound(new Bound(new Rectangle2D.Double(0.0, 20.0, 40.0, 15.0)));
        this.imageMap.get(last + 6).setBound(new Bound(new Rectangle2D.Double(0.0, 20.0, 40.0, 15.0)));
        this.imageMap.get(last + 11).setBound(new Bound(new Rectangle2D.Double(0.0, 45.0, 40.0, 27.0)));
        this.imageMap.get(last + 12).setBound(new Bound(new Rectangle2D.Double(0.0, 45.0, 40.0, 27.0)));
        Bound b1 = new Bound(new Ellipse2D.Double(20.0, -48.0, 120.0, 120.0));
        b1.intersect(new Bound(new Rectangle2D.Double(20.0, 12.0, 60.0, 60.0)));
        b1.add(new Bound(new Rectangle2D.Double(20.0, 0.0, 15.0, 12.0)));
        b1.subtract(new Bound(new Ellipse2D.Double(35.0, -21.0, 66.0, 66.0)));
        b1.subtract(new Bound(new Rectangle2D.Double(68.0, 35.0, 12.0, 10.0)));
        final Bound b2 = new Bound(new Ellipse2D.Double(-66.0, -60.0, 132.0, 132.0));
        b2.intersect(new Bound(new Rectangle2D.Double(0.0, 6.0, 66.0, 66.0)));
        b2.add(new Bound(new Rectangle2D.Double(45.0, 0.0, 21.0, 6.0)));
        b2.subtract(new Bound(new Ellipse2D.Double(-45.0, -45.0, 90.0, 90.0)));
        final Bound b3 = new Bound(new Ellipse2D.Double(-54.0, 20.0, 120.0, 120.0));
        b3.intersect(new Bound(new Rectangle2D.Double(6.0, 20.0, 60.0, 60.0)));
        b3.add(new Bound(new Rectangle2D.Double(0.0, 20.0, 6.0, 15.0)));
        b3.subtract(new Bound(new Ellipse2D.Double(-33.0, 35.0, 78.0, 78.0)));
        b3.subtract(new Bound(new Rectangle2D.Double(39.0, 74.0, 6.0, 6.0)));
        final Bound b4 = new Bound(new Ellipse2D.Double(20.0, 20.0, 120.0, 120.0));
        b4.intersect(new Bound(new Rectangle2D.Double(20.0, 20.0, 60.0, 60.0)));
        b4.subtract(new Bound(new Ellipse2D.Double(35.0, 35.0, 90.0, 90.0)));
        this.imageMap.get(last + 7).setBound(b4);
        this.imageMap.get(last + 8).setBound(b3);
        this.imageMap.get(last + 9).setBound(b1);
        this.imageMap.get(last + 10).setBound(b2);
        this.imageMap.get(last + 7).getImg().setNeedsBase(true);
        this.imageMap.get(last + 8).getImg().setNeedsBase(true);
        for (int x2 = 0; x2 < 6; ++x2) {
            this.imageMap.put(MapImage.nextKey(), new Tile(new MapImage(new DynamicImage("tiles/rock" + (x2 + 1) + ".png"), MapType.Ground)));
        }
        last = 33;
        this.imageMap.put(MapImage.nextKey(), new Tile(new MapImage(new DynamicImage("objects/rock1.png"), MapType.Object)));
        this.imageMap.put(MapImage.nextKey(), new Tile(new MapImage(new DynamicImage("objects/rock2.png"), MapType.Object)));
        this.imageMap.put(MapImage.nextKey(), new Tile(new MapImage(new DynamicImage("objects/tree1.png"), MapType.Object)));
        this.imageMap.put(MapImage.nextKey(), new Tile(new MapImage(new DynamicImage("objects/tree2.png"), MapType.Object)));
        this.imageMap.get(last + 1).getImg().setDrawOffset(-22, -28);
        this.imageMap.get(last + 2).getImg().setDrawOffset(-16, -50);
        this.imageMap.get(last + 3).getImg().setDrawOffset(-36, -100);
        this.imageMap.get(last + 4).getImg().setDrawOffset(-58, -83);
        this.imageMap.get(last + 1).setBound(new Bound(new Ellipse2D.Double(-6.0, -6.0, 12.0, 12.0)));
        this.imageMap.get(last + 2).setBound(new Bound(new Ellipse2D.Double(-6.0, -6.0, 12.0, 12.0)));
        this.imageMap.get(last + 3).setBound(new Bound(new Ellipse2D.Double(-16.0, -16.0, 32.0, 32.0)));
        this.imageMap.get(last + 4).setBound(new Bound(new Ellipse2D.Double(-30.0, -30.0, 60.0, 60.0)));
        for (int x2 = 0; x2 < 19; ++x2) {
            this.imageMap.put(MapImage.nextKey(), new Tile(new MapImage(new DynamicImage("tiles/pave" + (x2 + 1) + ".png"), MapType.Ground)));
        }
        for (int x2 = 0; x2 < 13; ++x2) {
            this.imageMap.put(MapImage.nextKey(), new Tile(new MapImage(new DynamicImage("tiles/fence" + (x2 + 1) + ".png"), MapType.Structure)));
        }
        last = 56;
        this.imageMap.get(last + 1).getImg().setDrawOffset(-19, -85);
        this.imageMap.get(last + 2).getImg().setDrawOffset(-20, -85);
        this.imageMap.get(last + 3).getImg().setDrawOffset(-20, -97);
        this.imageMap.get(last + 4).getImg().setDrawOffset(-16, -72);
        this.imageMap.get(last + 5).getImg().setDrawOffset(-20, -81);
        this.imageMap.get(last + 6).getImg().setDrawOffset(-13, -45);
        this.imageMap.get(last + 7).getImg().setDrawOffset(-20, -67);
        this.imageMap.get(last + 8).getImg().setDrawOffset(-13, -51);
        this.imageMap.get(last + 9).getImg().setDrawOffset(-17, -95);
        this.imageMap.get(last + 10).getImg().setDrawOffset(-22, -95);
        this.imageMap.get(last + 11).getImg().setDrawOffset(-19, -86);
        this.imageMap.get(last + 12).getImg().setDrawOffset(-20, -67);
        this.imageMap.get(last + 13).getImg().setDrawOffset(-20, -84);
        b1 = new Bound(new Rectangle2D.Double(-14.0, -40.0, 34.0, 40.0));
        b1.add(new Bound(new Rectangle2D.Double(-20.0, -25.0, 6.0, 25.0)));
        this.imageMap.get(last + 1).setBound(new Bound(new Rectangle2D.Double(-14.0, -25.0, 34.0, 25.0)));
        this.imageMap.get(last + 2).setBound(new Bound(new Rectangle2D.Double(-20.0, -25.0, 40.0, 25.0)));
        this.imageMap.get(last + 3).setBound(new Bound(new Rectangle2D.Double(-20.0, -25.0, 40.0, 25.0)));
        this.imageMap.get(last + 5).setBound(b1);
        this.imageMap.get(last + 6).setBound(new Bound(new Rectangle2D.Double(-14.0, -40.0, 34.0, 40.0)));
        this.imageMap.get(last + 7).setBound(new Bound(new Rectangle2D.Double(-20.0, -25.0, 40.0, 25.0)));
        this.imageMap.get(last + 8).setBound(new Bound(new Rectangle2D.Double(-14.0, -40.0, 34.0, 40.0)));
        this.imageMap.get(last + 9).setBound(new Bound(new Rectangle2D.Double(-20.0, -25.0, 40.0, 25.0)));
        this.imageMap.get(last + 10).setBound(new Bound(new Rectangle2D.Double(-20.0, -25.0, 40.0, 25.0)));
        this.imageMap.get(last + 11).setBound(new Bound(new Rectangle2D.Double(-14.0, -40.0, 34.0, 40.0)));
        this.imageMap.get(last + 12).setBound(new Bound(new Rectangle2D.Double(-20.0, -25.0, 40.0, 25.0)));
    }
    
    private void loadItems() {
        LostHavenRPG.itemMap = new HashMap<String, Item>();
        final DynamicImage dagger1 = new DynamicImage("items/dagger1.png");
        final DynamicImage dagger2 = new DynamicImage("items/dagger2.png");
        final DynamicImage sword1 = new DynamicImage("items/sword1.png");
        final DynamicImage sword2 = new DynamicImage("items/sword2.png");
        final DynamicImage maul1 = new DynamicImage("items/maul1.png");
        final DynamicImage maul2 = new DynamicImage("items/maul2.png");
        final DynamicImage helm1 = new DynamicImage("items/helm1.png");
        final DynamicImage helm2 = new DynamicImage("items/helm2.png");
        final DynamicImage armor1 = new DynamicImage("items/armor1.png");
        final DynamicImage armor2 = new DynamicImage("items/armor2.png");
        final DynamicImage gauntlets1 = new DynamicImage("items/gauntlets1.png");
        final DynamicImage gauntlets2 = new DynamicImage("items/gauntlets2.png");
        final DynamicImage boots1 = new DynamicImage("items/boots1.png");
        final DynamicImage boots2 = new DynamicImage("items/boots2.png");
        LostHavenRPG.itemMap.put("Dirk", new Weapon("Dirk", dagger2, 10, 0.9));
        LostHavenRPG.itemMap.put("Ripper", new Weapon("Ripper", dagger2, 18, 0.8));
        LostHavenRPG.itemMap.put("Assassin's Blade", new Weapon("Assassin's Blade", dagger1, 35, 0.7));
        LostHavenRPG.itemMap.get("Assassin's Blade").addEffect(new Effect.MoveSpeed(1.1));
        LostHavenRPG.itemMap.put("Wind Rider", new Weapon("Wind Rider", dagger2, 50, 0.5));
        LostHavenRPG.itemMap.get("Wind Rider").addEffect(new Effect.MoveSpeed(1.35));
        LostHavenRPG.itemMap.put("Blood Seeker", new Weapon("Blood Seeker", dagger1, 70, 0.6));
        LostHavenRPG.itemMap.get("Blood Seeker").addEffect(new Effect.MoveSpeed(1.25));
        LostHavenRPG.itemMap.get("Blood Seeker").addEffect(new Effect.Hitpoints(60));
        LostHavenRPG.itemMap.put("Long Sword", new Weapon("Long Sword", sword1, 14, 1.2));
        LostHavenRPG.itemMap.put("War Sword", new Weapon("War Sword", sword1, 30, 1.4));
        LostHavenRPG.itemMap.put("Tears of Hamlet", new Weapon("Tears of Hamlet", sword1, 50, 0.9));
        LostHavenRPG.itemMap.get("Tears of Hamlet").addEffect(new Effect.Hitpoints(15));
        LostHavenRPG.itemMap.put("Blade of Light", new Weapon("Blade of Light", sword2, 70, 0.9));
        LostHavenRPG.itemMap.get("Blade of Light").addEffect(new Effect.Hitpoints(25));
        LostHavenRPG.itemMap.put("Cursed Knight", new Weapon("Cursed Knight", sword2, 90, 0.8));
        LostHavenRPG.itemMap.get("Cursed Knight").addEffect(new Effect.MoveSpeed(1.2));
        LostHavenRPG.itemMap.get("Cursed Knight").addEffect(new Effect.Hitpoints(-40));
        LostHavenRPG.itemMap.put("Warhammer", new Weapon("Warhammer", maul1, 25, 1.6));
        LostHavenRPG.itemMap.put("Destructive Maul", new Weapon("Destructive Maul", maul1, 50, 1.5));
        LostHavenRPG.itemMap.put("Warrior's Might", new Weapon("Warrior's Might", maul2, 80, 1.2));
        LostHavenRPG.itemMap.get("Warrior's Might").addEffect(new Effect.Hitpoints(30));
        LostHavenRPG.itemMap.put("Ogre's Revenge", new Weapon("Ogre's Revenge", maul1, 120, 1.4));
        LostHavenRPG.itemMap.put("Storm Breaker", new Weapon("Storm Breaker", maul2, 100, 1.0));
        LostHavenRPG.itemMap.get("Storm Breaker").addEffect(new Effect.Hitpoints(80));
        LostHavenRPG.itemMap.put("Leather Helmet", new Armor("Leather Helmet", helm1, Armor.ArmorType.Head, 10));
        LostHavenRPG.itemMap.get("Leather Helmet").addEffect(new Effect.Hitpoints(10));
        LostHavenRPG.itemMap.put("Full Helm", new Armor("Full Helm", helm2, Armor.ArmorType.Head, 25));
        LostHavenRPG.itemMap.get("Full Helm").addEffect(new Effect.Hitpoints(20));
        LostHavenRPG.itemMap.get("Full Helm").addEffect(new Effect.MoveSpeed(0.9));
        LostHavenRPG.itemMap.put("Helmet of Wilhemina", new Armor("Helmet of Wilhemina", helm1, Armor.ArmorType.Head, 30));
        LostHavenRPG.itemMap.get("Helmet of Wilhemina").addEffect(new Effect.Hitpoints(30));
        LostHavenRPG.itemMap.put("Poseidon", new Armor("Poseidon", helm2, Armor.ArmorType.Head, 35));
        LostHavenRPG.itemMap.get("Poseidon").addEffect(new Effect.Hitpoints(30));
        LostHavenRPG.itemMap.get("Poseidon").addEffect(new Effect.Damage(10));
        LostHavenRPG.itemMap.get("Poseidon").addEffect(new Effect.MoveSpeed(0.95));
        LostHavenRPG.itemMap.put("Mask of Cronus", new Armor("Mask of Cronus", helm2, Armor.ArmorType.Head, 40));
        LostHavenRPG.itemMap.get("Mask of Cronus").addEffect(new Effect.Hitpoints(70));
        LostHavenRPG.itemMap.get("Mask of Cronus").addEffect(new Effect.AttackSpeed(1.2));
        LostHavenRPG.itemMap.get("Mask of Cronus").addEffect(new Effect.MoveSpeed(1.05));
        LostHavenRPG.itemMap.put("Chainmail", new Armor("Chainmail", armor1, Armor.ArmorType.Body, 30));
        LostHavenRPG.itemMap.get("Chainmail").addEffect(new Effect.Hitpoints(50));
        LostHavenRPG.itemMap.put("Full Plate", new Armor("Full Plate", armor2, Armor.ArmorType.Body, 60));
        LostHavenRPG.itemMap.get("Full Plate").addEffect(new Effect.Hitpoints(60));
        LostHavenRPG.itemMap.get("Full Plate").addEffect(new Effect.MoveSpeed(0.9));
        LostHavenRPG.itemMap.put("Menoetius", new Armor("Menoetius", armor1, Armor.ArmorType.Body, 60));
        LostHavenRPG.itemMap.get("Menoetius").addEffect(new Effect.Hitpoints(120));
        LostHavenRPG.itemMap.get("Menoetius").addEffect(new Effect.AttackSpeed(1.1));
        LostHavenRPG.itemMap.put("Coat of Themis", new Armor("Coat of Themis", armor1, Armor.ArmorType.Body, 100));
        LostHavenRPG.itemMap.get("Coat of Themis").addEffect(new Effect.Hitpoints(80));
        LostHavenRPG.itemMap.get("Coat of Themis").addEffect(new Effect.MoveSpeed(1.1));
        LostHavenRPG.itemMap.get("Coat of Themis").addEffect(new Effect.Damage(20));
        LostHavenRPG.itemMap.put("Kingship", new Armor("Kingship", armor2, Armor.ArmorType.Body, 120));
        LostHavenRPG.itemMap.get("Kingship").addEffect(new Effect.Hitpoints(200));
        LostHavenRPG.itemMap.get("Kingship").addEffect(new Effect.MoveSpeed(1.2));
        LostHavenRPG.itemMap.get("Kingship").addEffect(new Effect.Damage(40));
        LostHavenRPG.itemMap.put("Cloth Gloves", new Armor("Cloth Gloves", gauntlets1, Armor.ArmorType.Hands, 5));
        LostHavenRPG.itemMap.get("Cloth Gloves").addEffect(new Effect.Hitpoints(6));
        LostHavenRPG.itemMap.put("Golden Fist", new Armor("Golden Fist", gauntlets1, Armor.ArmorType.Hands, 10));
        LostHavenRPG.itemMap.get("Golden Fist").addEffect(new Effect.Hitpoints(6));
        LostHavenRPG.itemMap.get("Golden Fist").addEffect(new Effect.AttackSpeed(1.1));
        LostHavenRPG.itemMap.put("Gloves of Selene", new Armor("Gloves of Selene", gauntlets1, Armor.ArmorType.Hands, 15));
        LostHavenRPG.itemMap.get("Gloves of Selene").addEffect(new Effect.Hitpoints(30));
        LostHavenRPG.itemMap.put("Delta Force", new Armor("Delta Force", gauntlets2, Armor.ArmorType.Hands, 20));
        LostHavenRPG.itemMap.get("Delta Force").addEffect(new Effect.Hitpoints(20));
        LostHavenRPG.itemMap.get("Delta Force").addEffect(new Effect.MoveSpeed(1.05));
        LostHavenRPG.itemMap.get("Delta Force").addEffect(new Effect.AttackSpeed(1.05));
        LostHavenRPG.itemMap.put("Zeus", new Armor("Zeus", gauntlets2, Armor.ArmorType.Hands, 20));
        LostHavenRPG.itemMap.get("Zeus").addEffect(new Effect.Hitpoints(50));
        LostHavenRPG.itemMap.get("Zeus").addEffect(new Effect.MoveSpeed(1.1));
        LostHavenRPG.itemMap.get("Zeus").addEffect(new Effect.AttackSpeed(1.3));
        LostHavenRPG.itemMap.put("Cloth Boots", new Armor("Cloth Boots", boots1, Armor.ArmorType.Feet, 5));
        LostHavenRPG.itemMap.get("Cloth Boots").addEffect(new Effect.Hitpoints(8));
        LostHavenRPG.itemMap.put("Greaves", new Armor("Greaves", boots2, Armor.ArmorType.Feet, 20));
        LostHavenRPG.itemMap.get("Greaves").addEffect(new Effect.Hitpoints(20));
        LostHavenRPG.itemMap.get("Greaves").addEffect(new Effect.MoveSpeed(0.92));
        LostHavenRPG.itemMap.put("Leather Boots", new Armor("Leather Boots", boots1, Armor.ArmorType.Feet, 15));
        LostHavenRPG.itemMap.get("Leather Boots").addEffect(new Effect.Hitpoints(10));
        LostHavenRPG.itemMap.get("Leather Boots").addEffect(new Effect.MoveSpeed(1.2));
        LostHavenRPG.itemMap.put("Dragon's Scale", new Armor("Dragon's Scale", boots2, Armor.ArmorType.Feet, 30));
        LostHavenRPG.itemMap.get("Dragon's Scale").addEffect(new Effect.Hitpoints(10));
        LostHavenRPG.itemMap.get("Dragon's Scale").addEffect(new Effect.MoveSpeed(1.25));
        LostHavenRPG.itemMap.get("Dragon's Scale").addEffect(new Effect.AttackSpeed(1.1));
        LostHavenRPG.itemMap.put("Assassin's Step", new Armor("Assassin's Step", boots1, Armor.ArmorType.Feet, 20));
        LostHavenRPG.itemMap.get("Assassin's Step").addEffect(new Effect.Hitpoints(30));
        LostHavenRPG.itemMap.get("Assassin's Step").addEffect(new Effect.MoveSpeed(1.4));
        LostHavenRPG.itemMap.get("Assassin's Step").addEffect(new Effect.AttackSpeed(1.3));
    }
    
    private void loadCreatures() {
        Utils.loadCreatures(this.crMap, null);
        ((Enemy)this.crMap.get(1)).addItemDrop(LostHavenRPG.itemMap.get("Cloth Boots"), 0.3);
        ((Enemy)this.crMap.get(1)).addItemDrop(LostHavenRPG.itemMap.get("Leather Helmet"), 0.3);
        ((Enemy)this.crMap.get(1)).addItemDrop(LostHavenRPG.itemMap.get("Chainmail"), 0.3);
        ((Enemy)this.crMap.get(1)).addItemDrop(LostHavenRPG.itemMap.get("Cloth Gloves"), 0.3);
        ((Enemy)this.crMap.get(1)).addItemDrop(LostHavenRPG.itemMap.get("Dirk"), 0.3);
        ((Enemy)this.crMap.get(1)).addItemDrop(LostHavenRPG.itemMap.get("Long Sword"), 0.3);
        ((Enemy)this.crMap.get(1)).addItemDrop(LostHavenRPG.itemMap.get("Warhammer"), 0.3);
        ((Enemy)this.crMap.get(1)).addItemDrop(LostHavenRPG.itemMap.get("Greaves"), 0.15);
        ((Enemy)this.crMap.get(1)).addItemDrop(LostHavenRPG.itemMap.get("Full Helm"), 0.15);
        ((Enemy)this.crMap.get(1)).addItemDrop(LostHavenRPG.itemMap.get("Full Plate"), 0.15);
        ((Enemy)this.crMap.get(1)).addItemDrop(LostHavenRPG.itemMap.get("Golden Fist"), 0.15);
        ((Enemy)this.crMap.get(1)).addItemDrop(LostHavenRPG.itemMap.get("Ripper"), 0.15);
        ((Enemy)this.crMap.get(1)).addItemDrop(LostHavenRPG.itemMap.get("War Sword"), 0.15);
        ((Enemy)this.crMap.get(1)).addItemDrop(LostHavenRPG.itemMap.get("Destructive Maul"), 0.15);

        ((Enemy)this.crMap.get(2)).addItemDrop(LostHavenRPG.itemMap.get("Greaves"), 0.3);
        ((Enemy)this.crMap.get(2)).addItemDrop(LostHavenRPG.itemMap.get("Full Helm"), 0.3);
        ((Enemy)this.crMap.get(2)).addItemDrop(LostHavenRPG.itemMap.get("Full Plate"), 0.3);
        ((Enemy)this.crMap.get(2)).addItemDrop(LostHavenRPG.itemMap.get("Golden Fist"), 0.3);
        ((Enemy)this.crMap.get(2)).addItemDrop(LostHavenRPG.itemMap.get("Ripper"), 0.3);
        ((Enemy)this.crMap.get(2)).addItemDrop(LostHavenRPG.itemMap.get("War Sword"), 0.3);
        ((Enemy)this.crMap.get(2)).addItemDrop(LostHavenRPG.itemMap.get("Destructive Maul"), 0.3);
        ((Enemy)this.crMap.get(2)).addItemDrop(LostHavenRPG.itemMap.get("Leather Boots"), 0.15);
        ((Enemy)this.crMap.get(2)).addItemDrop(LostHavenRPG.itemMap.get("Helmet of Wilhemina"), 0.15);
        ((Enemy)this.crMap.get(2)).addItemDrop(LostHavenRPG.itemMap.get("Menoetius"), 0.15);
        ((Enemy)this.crMap.get(2)).addItemDrop(LostHavenRPG.itemMap.get("Gloves of Selene"), 0.15);
        ((Enemy)this.crMap.get(2)).addItemDrop(LostHavenRPG.itemMap.get("Assassin's Blade"), 0.15);
        ((Enemy)this.crMap.get(2)).addItemDrop(LostHavenRPG.itemMap.get("Tears of Hamlet"), 0.15);
        ((Enemy)this.crMap.get(2)).addItemDrop(LostHavenRPG.itemMap.get("Warrior's Might"), 0.15);

        ((Enemy)this.crMap.get(4)).addItemDrop(LostHavenRPG.itemMap.get("Dragon's Scale"), 0.5);
        ((Enemy)this.crMap.get(4)).addItemDrop(LostHavenRPG.itemMap.get("Poseidon"), 0.5);
        ((Enemy)this.crMap.get(4)).addItemDrop(LostHavenRPG.itemMap.get("Coat of Themis"), 0.5);
        ((Enemy)this.crMap.get(4)).addItemDrop(LostHavenRPG.itemMap.get("Delta Force"), 0.5);
        ((Enemy)this.crMap.get(4)).addItemDrop(LostHavenRPG.itemMap.get("Wind Rider"), 0.5);
        ((Enemy)this.crMap.get(4)).addItemDrop(LostHavenRPG.itemMap.get("Blade of Light"), 0.5);
        ((Enemy)this.crMap.get(4)).addItemDrop(LostHavenRPG.itemMap.get("Ogre's Revenge"), 0.5);
        ((Enemy)this.crMap.get(4)).addItemDrop(LostHavenRPG.itemMap.get("Assassin's Step"), 0.3);
        ((Enemy)this.crMap.get(4)).addItemDrop(LostHavenRPG.itemMap.get("Mask of Cronus"), 0.3);
        ((Enemy)this.crMap.get(4)).addItemDrop(LostHavenRPG.itemMap.get("Kingship"), 0.3);
        ((Enemy)this.crMap.get(4)).addItemDrop(LostHavenRPG.itemMap.get("Zeus"), 0.3);
        ((Enemy)this.crMap.get(4)).addItemDrop(LostHavenRPG.itemMap.get("Blood Seeker"), 0.3);
        ((Enemy)this.crMap.get(4)).addItemDrop(LostHavenRPG.itemMap.get("Cursed Knight"), 0.3);
        ((Enemy)this.crMap.get(4)).addItemDrop(LostHavenRPG.itemMap.get("Storm Breaker"), 0.3);

        ((Enemy)this.crMap.get(6)).addItemDrop(LostHavenRPG.itemMap.get("Leather Boots"), 0.3);
        ((Enemy)this.crMap.get(6)).addItemDrop(LostHavenRPG.itemMap.get("Helmet of Wilhemina"), 0.3);
        ((Enemy)this.crMap.get(6)).addItemDrop(LostHavenRPG.itemMap.get("Menoetius"), 0.3);
        ((Enemy)this.crMap.get(6)).addItemDrop(LostHavenRPG.itemMap.get("Gloves of Selene"), 0.3);
        ((Enemy)this.crMap.get(6)).addItemDrop(LostHavenRPG.itemMap.get("Assassin's Blade"), 0.3);
        ((Enemy)this.crMap.get(6)).addItemDrop(LostHavenRPG.itemMap.get("Tears of Hamlet"), 0.3);
        ((Enemy)this.crMap.get(6)).addItemDrop(LostHavenRPG.itemMap.get("Warrior's Might"), 0.3);
        ((Enemy)this.crMap.get(6)).addItemDrop(LostHavenRPG.itemMap.get("Dragon's Scale"), 0.15);
        ((Enemy)this.crMap.get(6)).addItemDrop(LostHavenRPG.itemMap.get("Poseidon"), 0.15);
        ((Enemy)this.crMap.get(6)).addItemDrop(LostHavenRPG.itemMap.get("Coat of Themis"), 0.15);
        ((Enemy)this.crMap.get(6)).addItemDrop(LostHavenRPG.itemMap.get("Delta Force"), 0.15);
        ((Enemy)this.crMap.get(6)).addItemDrop(LostHavenRPG.itemMap.get("Wind Rider"), 0.15);
        ((Enemy)this.crMap.get(6)).addItemDrop(LostHavenRPG.itemMap.get("Blade of Light"), 0.15);
        ((Enemy)this.crMap.get(6)).addItemDrop(LostHavenRPG.itemMap.get("Ogre's Revenge"), 0.15);
        
        this.map = Map.load("finalMap.txt", null, this.imageMap, this.crMap);
        (this.player = new Player("Japheth", this.crMap.get(3).xOffset, this.crMap.get(3).yOffset, 1, 0)).setModel(new Model(this.crMap.get(3).getModel()));
        this.player.setLoc(new Point(2800, 2880));
        this.player.setBound(this.crMap.get(3).getBound());
        this.player.setSelectionBound(this.crMap.get(3).getSelectionBound());
        this.player.strikeFrame = this.crMap.get(3).strikeFrame;
        this.player.setAttack(8, 0, 40, 60);
        this.player.setStats(8, 8, 8, 8);
        this.map.addCreature(70, 72, this.player);
        this.playerMapLoc = new Point(70, 72);
        (this.npc = new NPC("Seer", this.crMap.get(5).xOffset, this.crMap.get(5).yOffset)).setModel(new Model(this.crMap.get(5).getModel()));
        this.npc.setLoc(new Point(2800, 1600));
        this.npc.setBound(this.crMap.get(5).getBound());
        this.npc.setSelectionBound(this.crMap.get(5).getSelectionBound());
        this.npc.getModel().direction = Direction.South;
        this.npc.loadDialog("seerDialog.txt", this.m, 756);
        this.map.addCreature(70, 40, this.npc);
        (this.npc = new NPC("Wounded Resistance Fighter", this.crMap.get(0).xOffset, this.crMap.get(0).yOffset)).setModel(new Model(this.crMap.get(0).getModel()));
        this.npc.setLoc(new Point(1152, 1403));
        this.npc.setBound(this.crMap.get(0).getBound());
        this.npc.setSelectionBound(this.crMap.get(0).getSelectionBound());
        this.npc.getModel().direction = Direction.NorthEast;
        this.npc.loadDialog("nullDialog.txt", this.m, 756);
        this.map.addCreature(28, 35, this.npc);
        (this.npc = new NPC("Captured Resistance Fighter", this.crMap.get(0).xOffset, this.crMap.get(0).yOffset)).setModel(new Model(this.crMap.get(0).getModel()));
        this.npc.setLoc(new Point(2058, 1638));
        this.npc.setBound(this.crMap.get(0).getBound());
        this.npc.setSelectionBound(this.crMap.get(0).getSelectionBound());
        this.npc.getModel().direction = Direction.North;
        this.npc.loadDialog("nullDialog.txt", this.m, 756);
        this.map.addCreature(51, 40, this.npc);
        (this.npc = new NPC("Resistance Fighter", this.crMap.get(0).xOffset, this.crMap.get(0).yOffset)).setModel(new Model(this.crMap.get(0).getModel()));
        this.npc.setLoc(new Point(3204, 1345));
        this.npc.setBound(this.crMap.get(0).getBound());
        this.npc.setSelectionBound(this.crMap.get(0).getSelectionBound());
        this.npc.getModel().direction = Direction.South;
        this.npc.loadDialog("nullDialog.txt", this.m, 756);
        this.map.addCreature(80, 33, this.npc);
        (this.npc = new NPC("Resistance Fighter", this.crMap.get(0).xOffset, this.crMap.get(0).yOffset)).setModel(new Model(this.crMap.get(0).getModel()));
        this.npc.setLoc(new Point(2879, 1270));
        this.npc.setBound(this.crMap.get(0).getBound());
        this.npc.setSelectionBound(this.crMap.get(0).getSelectionBound());
        this.npc.getModel().direction = Direction.South;
        this.npc.loadDialog("nullDialog.txt", this.m, 756);
        this.map.addCreature(71, 31, this.npc);
        (this.npc = new NPC("Wayfarer", this.crMap.get(5).xOffset, this.crMap.get(5).yOffset)).setModel(new Model(this.crMap.get(5).getModel()));
        this.npc.setLoc(new Point(2880, 2718));
        this.npc.setBound(this.crMap.get(5).getBound());
        this.npc.setSelectionBound(this.crMap.get(5).getSelectionBound());
        this.npc.getModel().direction = Direction.South;
        this.npc.loadDialog("wayfarerDialog.txt", this.m, 756);
        this.map.addCreature(72, 67, this.npc);
    }
    
    private synchronized void handleGameEvents() {
        switch (this.gameState) {
            case Game: {
                if (this.player.isTalking() && this.curDialog == null) {
                    this.curDialog = this.player.getNPCTarget().dialog;
                    this.gameState = GameState.GameDialog;
                    final boolean showCharacter = false;
                    this.showInventory = showCharacter;
                    this.showQuests = showCharacter;
                    this.showCharacter = showCharacter;
                }
                this.executeAI();
                this.moveCreatures();
                break;
            }
        }
    }
    
    private synchronized void render(final Graphics g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, 800, 600);
        switch (this.gameState) {
            case Main: {
                this.wndMain.draw(g);
                break;
            }
            case LoadGame: {
                this.drawLoadGame(g);
                break;
            }
            case Credits: {
                this.drawCredits(g);
                break;
            }
            case Game: {
                this.playerLoc = this.player.loc;
                this.map.draw(g, this.playerLoc, this.bounds, this.passable);
                this.drawStatDisplay(g);
                break;
            }
            case GameDialog: {
                this.playerLoc = this.player.loc;
                this.map.draw(g, this.playerLoc, this.bounds, this.passable);
                this.drawStatDisplay(g);
                this.drawDialog(g);
                break;
            }
        }
        switch (this.auxState) {
            case MsgBox: {
                this.wndMessage.draw(g);
                break;
            }
        }
        if (this.showFps) {
            this.drawDiagnostics(g);
        }
    }
    
    public void showMessage(final String text) {
        this.auxState = AuxState.MsgBox;
        ((Label)this.wndMessage.getMember("label")).setText(text);
    }
    
    private void drawLoadGame(final Graphics g) {
        final Font tempFont = new Font("Arial", 0, 12);
        final FontMetrics metrics = g.getFontMetrics(tempFont);
        g.setFont(tempFont);
        g.setColor(Color.green);
        g.drawString("There is not a whole lot here right now. You can click anywhere on the screen to get back to the main menu.", 0, metrics.getHeight());
    }
    
    private void drawStatDisplay(final Graphics g) {
        g.setFont(this.guiFont12);
        g.setColor(new Color(60, 60, 60));
        final String hpString = "HP " + this.player.hitpoints + "/" + this.player.maxHitpoints;
        final String mpString = "MP " + this.player.manapoints + "/" + this.player.maxManapoints;
        final String xpString = "XP " + this.player.experience + "/" + this.player.getMaxExperience();
        if (this.minimizedGui) {
            this.miniGui.draw(g, 0, 600 - this.miniGui.getHeight());
            g.drawString(this.player.name, 24, 578);
            g.drawString(hpString, 110, 578);
            g.drawString(xpString, 190, 578);
            g.drawString("Level " + this.player.level, 24, 595);
            g.drawString(mpString, 110, 595);
            g.drawString("347", 227, 595);
        } else {
            this.fullGui.draw(g, 0, 600 - this.fullGui.getHeight());
            this.hpBar.draw(g, 147, 503, 147 + this.hpBar.getWidth() * this.player.hitpoints / this.player.maxHitpoints, 503 + this.hpBar.getHeight(), 0, 0, this.hpBar.getWidth() * this.player.hitpoints / this.player.maxHitpoints, this.hpBar.getHeight());
            this.mpBar.draw(g, 147, 537, 147 + this.mpBar.getWidth() * this.player.manapoints / this.player.maxManapoints, 537 + this.mpBar.getHeight(), 0, 0, this.mpBar.getWidth() * this.player.manapoints / this.player.maxManapoints, this.mpBar.getHeight());
            this.xpBar.draw(g, 12, 572, 12 + this.xpBar.getWidth() * this.player.experience / this.player.getMaxExperience(), 572 + this.xpBar.getHeight(), 0, 0, this.xpBar.getWidth() * this.player.experience / this.player.getMaxExperience(), this.xpBar.getHeight());
            g.drawString(this.player.name, 24, 515);
            g.drawString("Level " + this.player.level, 24, 533);
            g.drawString("Currency:", 24, 551);
            g.drawString("347", 97, 551);
            g.drawString(hpString, 147 + (this.hpBar.getWidth() - this.m.stringWidth(hpString)) / 2, 514);
            g.drawString(mpString, 147 + (this.mpBar.getWidth() - this.m.stringWidth(mpString)) / 2, 548);
            g.drawString(xpString, 12 + (this.xpBar.getWidth() - this.m.stringWidth(xpString)) / 2, 585);
        }
        this.fireIcon.draw(g, 580, 540);
        this.iceIcon.draw(g, 650, 540);
        this.windIcon.draw(g, 720, 540);
        if (this.showCharacter) {
            this.characterBg.draw(g, 0, 98);
            g.setColor(new Color(120, 240, 120));
            final DecimalFormat format = new DecimalFormat("0.00");
            g.drawString("Strength: " + this.player.stats[StatType.Strength.ordinal()], 22, 128);
            g.drawString("Dexterity: " + this.player.stats[StatType.Dexterity.ordinal()], 22, 143);
            g.drawString("Constitution: " + this.player.stats[StatType.Constitution.ordinal()], 22, 158);
            g.drawString("Intelligence: " + this.player.stats[StatType.Intelligence.ordinal()], 22, 173);
            g.drawString("Remaining Stat Points: " + this.player.statPoints, 22, 188);
            g.drawString("Damage: " + this.player.getDamage(), 22, 218);
            g.drawString("Attack Speed: " + format.format(this.player.getAttackSpeed()), 22, 233);
            g.drawString("Move Speed: " + format.format(this.player.moveSpeedMod), 22, 248);
            g.drawString("Armor Rating: " + this.player.stats[StatType.Armor.ordinal()], 22, 263);
            DynamicImage img;
            if (this.player.statPoints == 0) {
                img = this.darkPlus;
            }
            else {
                img = this.plus;
            }
            img.draw(g, 178, 118);
            img.draw(g, 178, 133);
            img.draw(g, 178, 148);
            img.draw(g, 178, 163);
            g.setColor(new Color(120, 120, 240));
            g.drawRect(105, 275, 40, 40);
            g.drawRect(105, 330, 40, 60);
            g.drawRect(105, 404, 40, 40);
            g.drawRect(40, 285, 40, 60);
            g.drawRect(40, 360, 40, 40);
            if (this.player.weapon != null) {
                this.player.weapon.getImg().draw(g, 40, 285);
            }
            if (this.player.armor[0] != null) {
                this.player.armor[0].getImg().draw(g, 105, 275);
            }
            if (this.player.armor[1] != null) {
                this.player.armor[1].getImg().draw(g, 40, 360);
            }
            if (this.player.armor[2] != null) {
                this.player.armor[2].getImg().draw(g, 105, 330);
            }
            if (this.player.armor[3] != null) {
                this.player.armor[3].getImg().draw(g, 105, 404);
            }
        }
        if (this.showQuests) {
            this.questsBg.draw(g, 600, 0);
        }
        if (this.showInventory) {
            this.inventoryBg.draw(g, 600, 270);
            g.setColor(new Color(30, 30, 60));
            for (int i = 0; i < this.player.invSpace.length + 1; ++i) {
                g.drawLine(620, 295 + 20 * i, 780, 295 + 20 * i);
            }
            for (int i = 0; i < this.player.invSpace[0].length + 1; ++i) {
                g.drawLine(620 + 20 * i, 295, 620 + 20 * i, 495);
            }
            for (final Item cur : this.player.inventory) {
                cur.getImg().draw(g, 620 + 20 * cur.invX, 295 + 20 * cur.invY);
            }
        }
    }
    
    private void drawDialog(final Graphics g) {
        this.dialogBg.draw(g, 0, 450);
        g.setFont(this.guiFont12);
        g.setColor(new Color(0, 0, 0));
        this.curDialog.text.draw(g, 22, 480);
        int pos = 0;
        if (this.curDialog.text.getLineCount() > 3) {
            pos = 480 + this.m.getHeight() * (this.curDialog.text.getLineCount() + 1);
        }
        else {
            pos = 480 + this.m.getHeight() * 4;
        }
        for (int i = 0; i < this.curDialog.getNumOptions(); ++i) {
            this.curDialog.getOption(i).draw(g, 22, pos);
            pos += this.m.getHeight() * this.curDialog.getOption(i).getLineCount();
        }
    }
    
    private void drawCredits(final Graphics g) {
        this.wndCredits.draw(g);
    }
    
    private void drawDiagnostics(final Graphics g) {
        this.wndDiagnostics.draw(g);
        g.setColor(Color.green);
        g.setFont(this.fontTT);
        g.drawString("Unthrottled FPS: " + this.lastFrameCount, 0, 15);
        g.drawString("Monitor Refresh Rate: " + this.refreshRate, 0, 30);
        g.drawString("Player Info", 0, 60);
        g.drawString("Location " + this.player.loc.x + "," + this.player.loc.y + " (" + this.player.getSortZ() + " sort offset)", 0, 75);
        g.drawString("Map Location: " + this.playerMapLoc.x + "," + this.playerMapLoc.y, 0, 90);
        g.drawString("Equals itself: " + this.player.compareTo((MapObject)this.player), 0, 105);
        g.drawString("Should be drawn: " + this.map.creatures.contains(this.player), 0, 120);
        g.drawString("Dead: " + this.player.dead, 0, 135);
        final Iterator<Creature> iter = this.map.creatures.iterator();
        int lineCount = 1;
        while (iter.hasNext()) {
            final Creature cur = iter.next();
            g.drawString(String.valueOf(cur.name) + " " + cur.loc.x / 40 + "," + cur.loc.y / 40, 280, lineCount * 15);
            ++lineCount;
        }
    }
    
    private int getDialogSelection(final MouseEvent e) {
        final int x = e.getX();
        final int y = e.getY();
        if (x < 22 || 778 < x) {
            return -1;
        }
        int curY;
        if (this.curDialog.text.getLineCount() > 3) {
            curY = 480 + this.m.getHeight() * this.curDialog.text.getLineCount();
        }
        else {
            curY = 480 + this.m.getHeight() * 3 + 3;
        }
        for (int i = 0; i < this.curDialog.getNumOptions(); ++i) {
            if (curY < y && y <= curY + this.m.getHeight() * this.curDialog.getOption(i).getLineCount()) {
                return i;
            }
            curY += this.m.getHeight() * this.curDialog.getOption(i).getLineCount();
        }
        return -1;
    }
    
    private synchronized void detectMouseOver(final Graphics g) {
        final Point e = MouseInfo.getPointerInfo().getLocation();
        if (e == null) {
            return;
        }
        g.setFont(this.guiFont12);
        switch (this.gameState) {
            case Main: {
                if (this.selectedButton != null) {
                    this.selectedButton.color = this.color1;
                }
                if (this.wndMain.getMember("new game").isClicked(e.x, e.y)) {
                    this.selectedButton = (Button)this.wndMain.getMember("new game");
                } else if (this.wndMain.getMember("load game").isClicked(e.x, e.y)) {
                    this.selectedButton = (Button)this.wndMain.getMember("load game");
                } else if (this.wndMain.getMember("game info").isClicked(e.x, e.y)) {
                    this.selectedButton = (Button)this.wndMain.getMember("game info");
                } else if (this.wndMain.getMember("credits").isClicked(e.x, e.y)) {
                    this.selectedButton = (Button)this.wndMain.getMember("credits");
                } else if (this.wndMain.getMember("quit").isClicked(e.x, e.y)) {
                    this.selectedButton = (Button)this.wndMain.getMember("quit");
                } else {
                    this.selectedButton = null;
                }
                if (this.selectedButton != null) {
                    this.selectedButton.color = this.color2;
                    break;
                }
                break;
            }
            case Game: {
                if (this.showCharacter) {
                    if (20 <= e.x && e.x <= 105) {
                        if (117 <= e.y && e.y <= 131) {
                            this.drawDesc(g, this.descStrength, e.x, e.y, 169);
                        }
                        else if (132 <= e.y && e.y <= 146) {
                            this.drawDesc(g, this.descDexterity, e.x, e.y, 169);
                        }
                        else if (147 <= e.y && e.y <= 161) {
                            this.drawDesc(g, this.descConstitution, e.x, e.y, 169);
                        }
                        else if (162 <= e.y && e.y <= 176) {
                            this.drawDesc(g, this.descIntelligence, e.x, e.y, 169);
                        }
                    }
                    if (this.equipWeapon.contains(e) && this.player.weapon != null) {
                        this.player.weapon.drawDesc(g, e.x, e.y, this.guiFont12, this.m);
                    }
                    else if (this.equipHead.contains(e) && this.player.armor[0] != null) {
                        this.player.armor[0].drawDesc(g, e.x, e.y, this.guiFont12, this.m);
                    }
                    else if (this.equipHands.contains(e) && this.player.armor[1] != null) {
                        this.player.armor[1].drawDesc(g, e.x, e.y, this.guiFont12, this.m);
                    }
                    else if (this.equipBody.contains(e) && this.player.armor[2] != null) {
                        this.player.armor[2].drawDesc(g, e.x, e.y, this.guiFont12, this.m);
                    }
                    else if (this.equipFeet.contains(e) && this.player.armor[3] != null) {
                        this.player.armor[3].drawDesc(g, e.x, e.y, this.guiFont12, this.m);
                    }
                }
                if (this.showInventory) {
                    if (this.curItem == null) {
                        final int x = (e.x - 620) / 20;
                        final int y = (e.y - 295) / 20;
                        if (x >= 0 && x < this.player.invSpace[0].length && y >= 0 && y < this.player.invSpace.length && this.player.invSpace[y][x] != null) {
                            this.player.invSpace[y][x].drawDesc(g, e.x, e.y, this.guiFont12, this.m);
                        }
                    }
                    else {
                        final int x = e.x + this.offset.x;
                        final int y = e.y + this.offset.y;
                        if (610 <= x && x + 20 * this.curItem.imgWidth < 630 + 20 * this.player.invSpace[0].length && 285 <= y && y + 20 * this.curItem.imgHeight < 305 + 20 * this.player.invSpace.length) {
                            if (this.player.itemFits(this.curItem, Math.round((x - 620) / 20.0f), Math.round((y - 295) / 20.0f))) {
                                g.setColor(this.blueHaze);
                            }
                            else {
                                g.setColor(this.redHaze);
                            }
                            g.fillRect(620 + Math.round((x - 620) / 20.0f) * 20, 295 + Math.round((y - 295) / 20.0f) * 20, 20 * this.curItem.imgWidth, 20 * this.curItem.imgHeight);
                        }
                    }
                }
                final Point mapPoint = new Point(this.playerLoc.x + e.x - 400, this.playerLoc.y + e.y - 300);
                final Iterator<Creature> iter = this.map.getCreaturesInVicinity(mapPoint, 2, 2).iterator();
                Creature bestTarget = null;
                while (iter.hasNext()) {
                    final Creature cur = iter.next();
                    if (cur == this.player) {
                        continue;
                    }
                    if (!cur.getSelectionBound().contains(mapPoint, cur) || (bestTarget != null && cur.loc.y <= bestTarget.loc.y)) {
                        continue;
                    }
                    bestTarget = cur;
                }
                if (bestTarget == null || bestTarget == this.player) {
                    this.cursor = this.yellowCursor;
                    break;
                }
                if (bestTarget.getClass() == Enemy.class) {
                    this.cursor = this.redCursor;
                    break;
                }
                if (bestTarget.getClass() == NPC.class) {
                    this.cursor = this.greenCursor;
                    break;
                }
                break;
            }
        }
        if (this.curItem != null) {
            this.curItem.getImg().draw(g, MouseInfo.getPointerInfo().getLocation().x + this.offset.x, MouseInfo.getPointerInfo().getLocation().y + this.offset.y);
        }
    }
    
    private void drawDesc(final Graphics g, final WrappedString desc, final int x, int y, final int width) {
        y -= 3 + desc.getLineCount() * desc.getMetrics().getHeight();
        g.setColor(Color.black);
        g.fillRect(x, y, width, 3 + desc.getLineCount() * desc.getMetrics().getHeight());
        g.setColor(new Color(120, 240, 120));
        g.drawRect(x, y, width, 3 + desc.getLineCount() * desc.getMetrics().getHeight());
        for (int i = 0; i < desc.getLineCount(); ++i) {
            g.drawString(desc.getLine(i), x + 3, y - 3 + (i + 1) * desc.getMetrics().getHeight());
        }
    }
    
    private void executeAI() {
        for (final Creature cr : this.map.creatureList) {
            cr.AI_move(this.player, this.map);
        }
    }
    
    private void moveCreatures() {
        for (final Creature cr : this.map.creatureList) {
            final int xOld = cr.loc.x / 40;
            final int yOld = cr.loc.y / 40;
            this.map.getLoc(xOld, yOld).getCreatures().remove(cr);
            this.map.creatures.remove(cr);
            cr.move(this.map.getObjectsInVicinity(cr.loc, 2, 3), this.map);
            final int xNew = cr.loc.x / 40;
            final int yNew = cr.loc.y / 40;
            this.map.getLoc(xNew, yNew).getCreatures().add(cr);
            if (this.map.xLow <= xNew && xNew <= this.map.xHigh && this.map.yLow <= yNew && yNew <= this.map.yHigh) {
                this.map.creatures.add(cr);
            }
        }
    }
    
    private synchronized void handleMouseInput(final MouseEvent e) {
        if (!this.started) {
            return;
        }
        this.selectText(null);
        switch (this.auxState) {
            case None: {
                switch (this.gameState) {
                    case Main: {
                        if (this.wndMain.getMember("new game").isClicked(e.getX(), e.getY())) {
                            this.gameState = GameState.Game;
                            break;
                        }
                        if (this.wndMain.getMember("load game").isClicked(e.getX(), e.getY()) || this.wndMain.getMember("game info").isClicked(e.getX(), e.getY())) {
                            break;
                        }
                        if (this.wndMain.getMember("credits").isClicked(e.getX(), e.getY())) {
                            this.gameState = GameState.Credits;
                            break;
                        }
                        if (this.wndMain.getMember("quit").isClicked(e.getX(), e.getY())) {
                            this.done = true;
                            break;
                        }
                        break;
                    }
                    case Credits: {
                        this.gameState = GameState.Main;
                        break;
                    }
                    case Game: {
                        Area curGui;
                        if (this.minimizedGui) {
                            curGui = this.miniBorder;
                            this.miniBtn = this.miniBtn2;
                        } else {
                            curGui = this.fullBorder;
                            this.miniBtn = this.miniBtn1;
                        }
                        if (e.getButton() == 1) {
                            if (this.showCharacter) {
                                if (this.player.statPoints > 0 && 178 <= e.getX() && e.getX() <= 188) {
                                    if (118 <= e.getY() && e.getY() <= 128) {
                                        final int[] stats = this.player.stats;
                                        final int ordinal = StatType.Strength.ordinal();
                                        ++stats[ordinal];
                                        final Player player = this.player;
                                        --player.statPoints;
                                    }
                                    else if (133 <= e.getY() && e.getY() <= 143) {
                                        final int[] stats2 = this.player.stats;
                                        final int ordinal2 = StatType.Dexterity.ordinal();
                                        ++stats2[ordinal2];
                                        final Player player2 = this.player;
                                        --player2.statPoints;
                                    }
                                    else if (148 <= e.getY() && e.getY() <= 158) {
                                        final int[] stats3 = this.player.stats;
                                        final int ordinal3 = StatType.Constitution.ordinal();
                                        ++stats3[ordinal3];
                                        final Player player3 = this.player;
                                        --player3.statPoints;
                                    }
                                    else if (163 <= e.getY() && e.getY() <= 173) {
                                        final int[] stats4 = this.player.stats;
                                        final int ordinal4 = StatType.Intelligence.ordinal();
                                        ++stats4[ordinal4];
                                        final Player player4 = this.player;
                                        --player4.statPoints;
                                    }
                                    this.player.propagateStatChanges();
                                }
                                if (this.equipWeapon.contains(e.getPoint())) {
                                    this.curItem = this.player.weapon;
                                    this.offset = new Point(40 - e.getX(), 285 - e.getY());
                                    this.equipNum = 4;
                                }
                                else if (this.equipHead.contains(e.getPoint())) {
                                    this.curItem = this.player.armor[0];
                                    this.offset = new Point(105 - e.getX(), 275 - e.getY());
                                    this.equipNum = 0;
                                }
                                else if (this.equipHands.contains(e.getPoint())) {
                                    this.curItem = this.player.armor[1];
                                    this.offset = new Point(40 - e.getX(), 360 - e.getY());
                                    this.equipNum = 1;
                                }
                                else if (this.equipBody.contains(e.getPoint())) {
                                    this.curItem = this.player.armor[2];
                                    this.offset = new Point(105 - e.getX(), 330 - e.getY());
                                    this.equipNum = 2;
                                }
                                else if (this.equipFeet.contains(e.getPoint())) {
                                    this.curItem = this.player.armor[3];
                                    this.offset = new Point(105 - e.getX(), 404 - e.getY());
                                    this.equipNum = 3;
                                }
                                this.equipped = true;
                            }
                            if (this.showInventory) {
                                final int x = (e.getX() - 620) / 20;
                                final int y = (e.getY() - 295) / 20;
                                if (x >= 0 && x < this.player.invSpace[0].length && y >= 0 && y < this.player.invSpace.length && this.player.invSpace[y][x] != null) {
                                    this.curItem = this.player.invSpace[y][x];
                                    this.offset = new Point(620 + 20 * this.curItem.invX - e.getX(), 295 + 20 * this.curItem.invY - e.getY());
                                    this.equipped = false;
                                }
                            }
                            if (!curGui.contains(e.getPoint())) {
                                break;
                            }
                            if (this.miniBtn.contains(e.getPoint())) {
                                this.minimizedGui = !this.minimizedGui;
                                break;
                            }
                            if (this.iBtn.contains(e.getPoint())) {
                                this.showInventory = !this.showInventory;
                                break;
                            }
                            if (this.eBtn.contains(e.getPoint())) {
                                this.showCharacter = !this.showCharacter;
                                break;
                            }
                            if (this.qBtn.contains(e.getPoint())) {
                                this.showQuests = !this.showQuests;
                                break;
                            }
                            if (this.mainBtn.contains(e.getPoint())) {
                                this.gameState = GameState.Main;
                                break;
                            }
                        } else {
                            if (e.getButton() != 3) {
                                break;
                            }
                            if (curGui.contains(e.getPoint())) {
                                return;
                            }
                            final Point target = new Point(this.playerLoc.x + e.getX() - 400, this.playerLoc.y + e.getY() - 300);
                            final Iterator<Creature> iter = this.map.getCreaturesInVicinity(target, 2, 2).iterator();
                            Creature bestTarget = null;
                            final Creature oldTarget = this.player.enemyTarget;
                            while (iter.hasNext()) {
                                final Creature cur = iter.next();
                                if (cur != this.player) {
                                    if (cur.dead) {
                                        continue;
                                    }
                                    if (!cur.getSelectionBound().contains(target, cur) || (bestTarget != null && cur.loc.y <= bestTarget.loc.y)) {
                                        continue;
                                    }
                                    bestTarget = cur;
                                }
                            }
                            this.player.setEnemyTarget(bestTarget, this.map);
                            if (bestTarget == null) {
                                this.player.setTarget(target, this.map);
                            }
                            if (this.player.getModel().action == Action.Attacking && this.player.enemyTarget != oldTarget) {
                                this.player.getModel().getCurrentAnimation().reset();
                                this.player.getModel().action = Action.Walking;
                                break;
                            }
                        }
                        break;
                    }
                    case GameDialog: {
                        final int selection = this.getDialogSelection(e);
                        if (selection == -1) {
                            break;
                        }
                        this.curDialog = this.player.getNPCTarget().processDialog(this.curDialog, selection, this.player);
                        if (this.curDialog == null) {
                            this.player.endDialog();
                            this.gameState = GameState.Game;
                            break;
                        }
                        break;
                    }
                }
                break;
            }
            case MsgBox: {
                if (this.wndMessage.getMember("button").isClicked(e.getX(), e.getY())) {
                    this.auxState = AuxState.None;
                    break;
                }
                break;
            }
        }
    }
    
    private synchronized void handleMouseRelease(final MouseEvent e) {
        if (this.curItem == null) {
            return;
        }
        final Rectangle item = new Rectangle(MouseInfo.getPointerInfo().getLocation().x + this.offset.x, MouseInfo.getPointerInfo().getLocation().y + this.offset.y, this.curItem.imgWidth * 20, this.curItem.imgHeight * 20);
        if (this.showCharacter && !this.equipped) {
            if (this.equipWeapon.intersects(item) && this.curItem.getClass() == Weapon.class) {
                this.player.drop(this.curItem);
                this.player.equipWeapon((Weapon)this.curItem);
            }
            else if (this.equipHead.intersects(item) && this.curItem.getClass() == Armor.class && ((Armor)this.curItem).getType() == Armor.ArmorType.Head) {
                this.player.drop(this.curItem);
                this.player.equipArmor(0, (Armor)this.curItem);
            }
            else if (this.equipHands.intersects(item) && this.curItem.getClass() == Armor.class && ((Armor)this.curItem).getType() == Armor.ArmorType.Hands) {
                this.player.drop(this.curItem);
                this.player.equipArmor(1, (Armor)this.curItem);
            }
            else if (this.equipBody.intersects(item) && this.curItem.getClass() == Armor.class && ((Armor)this.curItem).getType() == Armor.ArmorType.Body) {
                this.player.drop(this.curItem);
                this.player.equipArmor(2, (Armor)this.curItem);
            }
            else if (this.equipFeet.intersects(item) && this.curItem.getClass() == Armor.class && ((Armor)this.curItem).getType() == Armor.ArmorType.Feet) {
                this.player.drop(this.curItem);
                this.player.equipArmor(3, (Armor)this.curItem);
            }
        }
        if (this.showInventory) {
            final int x = e.getX() + this.offset.x;
            final int y = e.getY() + this.offset.y;
            if (610 <= x && x + 20 * this.curItem.imgWidth < 630 + 20 * this.player.invSpace[0].length && 285 <= y && y + 20 * this.curItem.imgHeight < 305 + 20 * this.player.invSpace.length) {
                final int xCoord = Math.round((x - 620) / 20.0f);
                final int yCoord = Math.round((y - 295) / 20.0f);
                if (this.equipped) {
                    this.player.pickUp(this.curItem, xCoord, yCoord);
                    if (this.equipNum == 4) {
                        this.player.unequipWeapon((Weapon)this.curItem);
                    }
                    else {
                        this.player.unequipArmor(this.equipNum, (Armor)this.curItem);
                    }
                }
                else {
                    this.player.moveItem(this.curItem, xCoord, yCoord);
                }
            }
        }
        boolean dropItem = true;
        if (this.showCharacter && this.areaCharacter.intersects(item)) {
            dropItem = false;
        }
        else if (this.showInventory && this.areaInventory.intersects(item)) {
            dropItem = false;
        }
        else if (this.showQuests && this.areaQuests.intersects(item)) {
            dropItem = false;
        }
        else if (this.minimizedGui) {
            if (this.miniBorder.intersects(item)) {
                dropItem = false;
            }
        }
        else if (this.fullBorder.intersects(item)) {
            dropItem = false;
        }
        if (dropItem) {
            if (this.equipped) {
                if (this.equipNum == 4) {
                    this.player.unequipWeapon((Weapon)this.curItem);
                }
                else {
                    this.player.unequipArmor(this.equipNum, (Armor)this.curItem);
                }
            }
            else {
                this.player.drop(this.curItem);
            }
        }
        this.curItem = null;
    }
    
    private synchronized void handleKeyboardInput(final KeyEvent e) {
        if (this.selectedText != null) {
            this.selectedText.handleEvent(e);
        }
        else if (e.getKeyCode() == 27) {
            if (this.gameState == GameState.Game) {
                this.gameState = GameState.Main;
            }
            else {
                this.done = true;
            }
        }
        else if (e.getKeyCode() == 83) {
            this.showFps = !this.showFps;
        }
        else if (e.getKeyCode() == 90 && this.gameState == GameState.Game) {
            this.bounds = !this.bounds;
        }
        else if (e.getKeyCode() == 88 && this.gameState == GameState.Game) {
            this.passable = !this.passable;
        }
    }
    
    @Override
    public void mousePressed(final MouseEvent e) {
        this.handleMouseInput(e);
    }
    
    @Override
    public void mouseReleased(final MouseEvent e) {
        this.handleMouseRelease(e);
    }
    
    @Override
    public void mouseEntered(final MouseEvent e) {
    }
    
    @Override
    public void mouseExited(final MouseEvent e) {
    }
    
    @Override
    public void mouseClicked(final MouseEvent e) {
    }
    
    @Override
    public void keyTyped(final KeyEvent e) {
    }
    
    @Override
    public synchronized void keyPressed(final KeyEvent e) {
        this.handleKeyboardInput(e);
    }
    
    @Override
    public void keyReleased(final KeyEvent e) {
    }
    
    private void selectText(final Textbox text) {
        if (this.selectedText != null) {
            this.selectedText.setSelected(false);
        }
        if ((this.selectedText = text) != null) {
            text.setSelected(true);
        }
    }
    
    public static void main(final String[] args) {
        try {
            final PrintStream st = new PrintStream(new FileOutputStream("err.txt", true));
            System.setErr(st);
            System.setOut(st);
            System.out.println("-----[ Session started on " + Utils.dateString() + " ]-----");
            final GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            final GraphicsDevice device = env.getDefaultScreenDevice();
            new LostHavenRPG(device);
        } catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
    
    public enum AuxState
    {
        None("None", 0), 
        MsgBox("MsgBox", 1);
        
        private AuxState(final String s, final int n) {
        }
    }
    
    public enum GameState
    {
        Loading("Loading", 0), 
        Main("Main", 1), 
        CreateAccount("CreateAccount", 2), 
        LoadGame("LoadGame", 3), 
        Credits("Credits", 4), 
        Game("Game", 5), 
        GameDialog("GameDialog", 6);
        
        private GameState(final String s, final int n) {
        }
    }
}
