#version 410

#define MAX_NUM_OBJECTS 1024

uniform sampler2D basic_texture;
uniform vec3 laser_color;

// use this to allow lasers of different colors,
// while still drawing them all at the same time
layout (std140) uniform colors {
  vec3 laser_colors[MAX_NUM_OBJECTS];
};

in vec2 texture_coordinates;

out vec4 frag_color;

void main() {
  vec4 texel = texture(basic_texture, texture_coordinates);

  frag_color = vec4(texel.r * laser_color.r, texel.g * laser_color.g, texel.b * laser_color.b, texel.a);
}