#version 410

in vec3 position_eye, normal_eye, color, light_position_eye;

out vec4 frag_color;

// fixed point light properties
vec3 Ls = vec3(1.0, 1.0, 1.0); // white specular colour
vec3 Ld = vec3(0.7, 0.7, 0.7); // dull white diffuse light colour
vec3 La = vec3(0.2, 0.2, 0.2); // grey ambient colour

// surface reflectance
vec3 Ks = vec3(1.0, 1.0, 1.0); // fully reflect specular light
vec3 Kd = vec3(1.0, 0.5, 0.0); // orange diffuse surface reflectance
vec3 Ka = vec3(0.2, 0.2, 0.2); // fully reflect ambient light
float specular_exponent = 100.0; // specular 'power'

void main() {
  // ambient intensity
  vec3 Ia = La * Ka;

  vec3 direction_to_light_eye = normalize(light_position_eye - position_eye);
  float dot_prod = max(dot(direction_to_light_eye, normal_eye), 0.0);

  // diffuse intensity
  vec3 Id = Ls * color * dot_prod;

  vec3 reflection_eye = reflect(-direction_to_light_eye, normal_eye);
  vec3 surface_to_viewer_eye = normalize(-position_eye);
  float dot_prod_specular = max(dot(reflection_eye, surface_to_viewer_eye), 0.0);
  float specular_factor = pow(dot_prod_specular, specular_exponent);

  // specular intensity
  vec3 Is = Ls * Ks * specular_factor;

  frag_color = vec4(Is + Id + Ia, 1.0);
}
