#version 450
#extension GL_ARB_separate_shader_objects : enable

layout(binding = 1) uniform sampler2D texSampler;
layout(binding = 2) uniform sampler2D uiTexSampler;

layout(location = 0) in vec3 fragColor;
layout(location = 1) in vec2 fragTexCoord;
layout(location = 2) flat in uint isOverlay;

layout(location = 0) out vec4 outColor;

void main() {
   if (isOverlay == 1) {
      outColor = texture(uiTexSampler, fragTexCoord);
   } else {
      outColor = vec4(fragColor * texture(texSampler, fragTexCoord).rgb, 1.0);
   }
}