package com.example.helloandroid;

import java.util.ArrayList;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Paint.FontMetrics;

public class Planet {
	int radius;
	int regenRate;	// ships per second
	private int x;
	private int y;
	int faction;
	int numShips;
	boolean selected;
	private Bitmap selection;
	
	public Planet(int radius, int x, int y) {
		this.radius = radius;
		this.x = x;
		this.y = y;
		faction = 0;
		numShips = 0;
		selected = false;
		
		regenRate = 0;	//change this to some expression / funcion call
		
		int size = getRadius()+15;
		
		selection = Bitmap.createBitmap(size*2, size*2, Bitmap.Config.ARGB_8888);
		Canvas c = new Canvas(selection);
		c.drawColor(Color.argb(0, 0, 0, 0));
		
		Paint p = new Paint();
        p.setAntiAlias(true);
		
		p.setColor(Color.argb(255, 255, 255, 255));
		c.drawCircle(size, size, getRadius()+11, p);
		
		p.setColor(Color.argb(255, 100, 100, 100));
		c.drawCircle(size, size, getRadius()+5, p);
		
		for(int i=0; i<size*2; i++) {
			for(int j=0; j<size*2; j++) {
				if(selection.getPixel(i,j) == Color.argb(255, 100, 100, 100))
					selection.setPixel(i, j, Color.argb(0, 0, 0, 0));
			}
		}
	}
	
	public int getX() {
		return x;
	}
	
	public int getY() {
		return y;
	}
	
	public int getRadius() {
		return radius;
	}
	
	public int getNumShips() {
		return numShips;
	}
	
	public boolean isSelected() {
		return selected;
	}
	
	public void setNumShips(int num) {
		numShips = num;
	}

	public void setFaction(int faction) {
		this.faction = faction;
	}
	
	public void select() {
		selected = true;
	}
	
	public void unselect() {
		selected = false;
	}
	
	public void draw(Canvas canvas, Paint linePaint, Paint textPaint) {
		FontMetrics metrics = textPaint.getFontMetrics();
		
		int c, prevC = linePaint.getColor();
		
		if(selected) {
			//drawSelectionCircle(canvas);
		}
		
		switch(faction) {
		case 0:
			c = Color.argb(255, 100, 100, 100);
			break;
		case 1:
			c = Color.argb(255, 255, 0, 0);
			break;
		case 2:
			c = Color.argb(255, 0, 255, 0);
			break;
		case 3:
			c = Color.argb(255, 0, 0, 255);
			break;
		case 4:
			c = Color.argb(255, 255, 255, 0);
			break;
		default:
			c = prevC;
		}
		
		linePaint.setColor(c);
		
		canvas.drawCircle(x, y, getRadius(), linePaint);
    	canvas.drawText(Integer.toString(numShips), x-textPaint.measureText(Integer.toString(numShips))/2, y-(metrics.ascent+metrics.descent)/2, textPaint);
	
    	linePaint.setColor(prevC);
	}
	
	public void drawSelectionCircle(Canvas canvas) {
		int size = getRadius()+15;
		
		canvas.drawBitmap(selection, x-size, y-size, null);
	}
	
	public void update() {
		if(faction != 0)
			numShips++;
		
	}
	
	public void sendFleet(Planet p, int numShips) {
		
	}
	
	public boolean contains(int x, int y) {
		double dist = Math.sqrt(Math.pow(this.x-x, 2) + Math.pow(this.y-y, 2));
		
		return dist <= this.radius;
	}
	
	public boolean collides(Planet p) {
		double dist = Math.sqrt(Math.pow(this.x-p.x, 2) + Math.pow(this.y-p.y, 2));
		
		return dist <= this.radius + p.radius;
	}
	
	public static boolean collisionDetected(Planet p, ArrayList<Planet> curPlanets) {
		for(Planet p2 : curPlanets) {
			if(p.collides(p2))
				return true;
		}
		
		return false;
	}
}
