import java.util.*;

/*
 * This thread handles events in the world such as monster movement and player movement and other things that do not require player input. It
 * also sends information to all players to notify them of changes in the world.
 */

public class ProcessingThread extends Thread {
	LostHavenServer server;

    public ProcessingThread(LostHavenServer main) {
    	super("ProcessingThread");
    	server = main;
    }
    
    public void run() {
    	while(server.running) {
    		updateWorld();
    		//sendInfo();
    		try {
    			Thread.sleep(1);
    		}catch(InterruptedException ie) {
    			ie.printStackTrace();
    		}
    	}
	}
    
    private void updateWorld() {
    	Iterator<String> iter = server.orderedOnline.iterator();
    	Player p;
    	Point loc, target;
    	
    	while(iter.hasNext()) {
    		p = server.registered.get(iter.next());
    		loc = p.getLoc();
    		target = p.getTarget();
    		
    		//if((System.currentTimeMillis()-p.getLastMoved())>=10) {
	    		if(Point.dist(loc, target) <= p.getSpeed())
	    			p.setLoc(target);
	    		else {
	    			int xChange = new Double(p.getSpeed()*(System.currentTimeMillis()-p.getLastMoved())*(target.getX()-loc.getX())/Point.dist(loc, target)/20).intValue();
	    			int yChange = new Double(p.getSpeed()*(System.currentTimeMillis()-p.getLastMoved())*(target.getY()-loc.getY())/Point.dist(loc, target)/20).intValue();
	    			
	    			p.setLoc(new Point(p.getLoc().getX()+xChange, p.getLoc().getY()+yChange));
	    		}
	    		p.setLastMoved(System.currentTimeMillis());
	    		server.sendAll(MessageType.Movement, p.getName()+" "+p.getLoc().toString());
    		//}
    	}
    }
}
