#ifndef _GAME_GUI_H
#define _GAME_GUI_H

#ifdef GAMEGUI_INCLUDE_VULKAN
   #include <vulkan/vulkan.h>
#endif

#include <string>
#include <vector>

using namespace std;

#define RTWO_SUCCESS true
#define RTWO_ERROR false

class GameGui {
   public:
      virtual ~GameGui() {};

      virtual bool Init() = 0;
      virtual void Shutdown() = 0;

      virtual void* CreateWindow(const string& title, unsigned int width, unsigned int height) = 0;
      virtual void DestroyWindow() = 0;

#ifdef GAMEGUI_INCLUDE_VULKAN
      virtual bool CreateVulkanSurface(VkInstance instance, VkSurfaceKHR* surface) = 0;
#endif

      virtual vector<const char*> GetRequiredExtensions() = 0;
      virtual void GetWindowSize(int* width, int* height) = 0;
};

#endif // _GAME_GUI_H