package main;

import java.io.IOException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.BufferedReader;

public class Utils {
    private static boolean RUNNING_FROM_JAR = true;
    private static Utils classLoaderReference = null;

    public static BufferedReader loadTextFile(final String fileName) throws IOException {
        if (Utils.RUNNING_FROM_JAR) {
            if (Utils.classLoaderReference == null) {
                Utils.classLoaderReference = new Utils();
            }
            return new BufferedReader(new InputStreamReader(Utils.classLoaderReference.getClass().getResourceAsStream("/" + fileName)));
        }
        return new BufferedReader(new FileReader(fileName));
    }
}
