package gamegui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class TabbedWindow extends Member {

  private ArrayList<Window> windows;  
  private ArrayList<String> windowLabels;
  private Window activeWindow;
  private int tabHeight;
  private Font tabFont;

  public TabbedWindow(String newName, int newX, int newY, int newWidth, int newHeight, int newTabHeight, Font newFont) {
    super(newName, newX, newY, newWidth, newHeight);
    this.windows = new ArrayList<Window>();
    this.windowLabels = new ArrayList<String>();
    this.tabHeight = newTabHeight;
    this.activeWindow = null;
    this.tabFont = newFont;
  }

  public void add(Window newWindow, String name) {
    newWindow.offset(getX(), getY() + this.tabHeight);
    if (this.activeWindow == null) {
      this.activeWindow = newWindow;
    }
    this.windows.add(newWindow);
    this.windowLabels.add(name);
  }

  public void clear() {
    this.activeWindow = this.windows.get(0);
    for (int x = 0; x < this.windows.size(); x++) {
      ((Window)this.windows.get(x)).clear();
    }
  }

  public void offset(int xOffset, int yOffset) {
    super.offset(xOffset, yOffset);
    for (int x = 0; x < this.windows.size(); x++) {
      ((Window)this.windows.get(x)).offset(xOffset, yOffset);
    }
  }

  public Window getWindow(String aName) {
    for (int x = 0; x < this.windows.size(); x++) {
      if (((Window)this.windows.get(x)).getName().equals(aName)) {
        return this.windows.get(x);
      }
    }
    return null;
  }

  public boolean handleEvent(MouseEvent e) {
    for (int x = 0; x < this.windows.size(); x++) {
      if (isClicked(getX() + x * getWidth() / this.windows.size(), getY(), getWidth() / this.windows.size(), this.tabHeight, e.getX(), e.getY())) {
        this.activeWindow = this.windows.get(x);
        return true;
      }
    }
    return this.activeWindow.handleEvent(e);
  }

  private boolean isClicked(int x, int y, int width, int height, int mouseX, int mouseY) {
    return (x <= mouseX && mouseX <= x + width && y <= mouseY && mouseY <= y + height);
  }

  public void draw(Graphics g) {
    FontMetrics metrics = g.getFontMetrics(this.tabFont);
    g.setColor(Color.black);
    g.fillRect(getX(), getY(), getWidth(), getHeight());
    g.setFont(this.tabFont);
    for (int x = 0; x < this.windows.size(); x++) {
      g.setColor(Color.green);
      g.drawString(this.windowLabels.get(x), getX() + x * getWidth() / this.windows.size() + (getWidth() / this.windows.size() - metrics.stringWidth(this.windowLabels.get(x))) / 2, getY() + (this.tabHeight + metrics.getHeight()) / 2 - 2);
      g.setColor(Color.red);
      g.drawLine(getX() + x * getWidth() / this.windows.size(), getY(), getX() + x * getWidth() / this.windows.size(), getY() + this.tabHeight);
      if (((Window)this.windows.get(x)).equals(this.activeWindow)) {
        ((Member)this.windows.get(x)).draw(g);
        g.setColor(Color.red);
        g.drawRect(getX(), getY(), getWidth(), getHeight());
        g.drawLine(getX(), getY() + this.tabHeight, getX() + x * getWidth() / this.windows.size(), getY() + this.tabHeight);
        g.drawLine(getX() + (x + 1) * getWidth() / this.windows.size(), getY() + this.tabHeight, getX() + getWidth(), getY() + this.tabHeight);
      }
    }
  }

  public String getActive() {
    if (this.activeWindow != null) {
      return this.activeWindow.getName();
    }
    return "";
  }
}
