package gamegui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class Menu extends Member {

  private ArrayList<String> items;
  private int selectedIndex;
  private String label;
  private Font font;
  private boolean open;
  private FontMetrics metrics;

  public Menu(String newName, int newX, int newY, int newWidth, int newHeight, String newLabel, Font newFont) {
    super(newName, newX, newY, newWidth, newHeight);
    this.items = new ArrayList<String>();
    this.selectedIndex = -1;
    this.label = newLabel;
    this.font = newFont;
    this.open = false;
  }

  public boolean handleEvent(MouseEvent e) {
    if (getX() + this.metrics.stringWidth(this.label) + 4 <= e.getX() && e.getX() <= getX() + getWidth() && getY() + getHeight() <= e.getY() && e.getY() <= getY() + getHeight() + 15 * this.items.size() && this.open) {
      this.selectedIndex = (e.getY() - getY() - getHeight()) / 15;
      this.open = false;
      return true;
    }
    if (getX() + getWidth() - getHeight() <= e.getX() && e.getX() <= getX() + getWidth() && getY() <= e.getY() && e.getY() <= getY() + getHeight()) {
      this.open = !this.open;
      return true;
    }
    return false;
  }

  public void clear() {
    if (this.selectedIndex != -1)
      this.selectedIndex = 0; 
  }

  public void draw(Graphics g) {
    this.metrics = g.getFontMetrics(this.font);
    g.setColor(Color.black);
    g.fillRect(getX(), getY(), getWidth(), getHeight());
    g.setColor(Color.red);
    g.drawRect(getX(), getY(), getWidth(), getHeight());
    g.drawLine(getX() + this.metrics.stringWidth(this.label) + 4, getY(), getX() + this.metrics.stringWidth(this.label) + 4, getY() + getHeight());
    g.drawLine(getX() + getWidth() - getHeight(), getY(), getX() + getWidth() - getHeight(), getY() + getHeight());
    g.drawLine(getX() + getWidth() - getHeight() * 17 / 20, getY() + getHeight() * 3 / 20, getX() + getWidth() - getHeight() * 3 / 20, getY() + getHeight() * 3 / 20);
    g.drawLine(getX() + getWidth() - getHeight() * 17 / 20, getY() + getHeight() * 3 / 20, getX() + getWidth() - getHeight() / 2, getY() + getHeight() * 17 / 20);
    g.drawLine(getX() + getWidth() - getHeight() / 2, getY() + getHeight() * 17 / 20, getX() + getWidth() - getHeight() * 3 / 20, getY() + getHeight() * 3 / 20);
    g.setColor(Color.green);
    g.setFont(this.font);
    g.drawString(this.label, getX() + 2, getY() + (getHeight() + this.metrics.getHeight()) / 2 - 2);
    g.drawString(this.items.get(this.selectedIndex), getX() + this.metrics.stringWidth(this.label) + 8, getY() + (getHeight() + this.metrics.getHeight()) / 2 - 2);
    if (this.open) {
      g.setColor(Color.black);
      g.fillRect(getX() + this.metrics.stringWidth(this.label) + 4, getY() + getHeight(), getWidth() - this.metrics.stringWidth(this.label) - 4, this.items.size() * 15);
      g.setColor(Color.red);
      g.drawRect(getX() + this.metrics.stringWidth(this.label) + 4, getY() + getHeight(), getWidth() - this.metrics.stringWidth(this.label) - 4, this.items.size() * 15);
      if (this.selectedIndex != -1) {
        g.setColor(Color.blue);
        g.fillRect(getX() + this.metrics.stringWidth(this.label) + 5, getY() + getHeight() + 1 + 15 * this.selectedIndex, getWidth() - this.metrics.stringWidth(this.label) - 5, 14);
      }
      g.setColor(Color.green);
      for (int x = 0; x < this.items.size(); x++)
        g.drawString(this.items.get(x), getX() + this.metrics.stringWidth(this.label) + 8, getY() + (getHeight() + this.metrics.getHeight()) / 2 + 15 * (x + 1)); 
    }
  }

  public void add(String newString) {
    this.selectedIndex = 0;
    this.items.add(newString);
  }

  public String getSelected() {
    return this.items.get(this.selectedIndex);
  }
}
