#version 450
#extension GL_ARB_separate_shader_objects : enable

struct Object {
   mat4 model;
};

layout (binding = 0) uniform UniformBufferObject {
   mat4 view;
   mat4 proj;
} ubo;

layout(binding = 1) readonly buffer StorageBufferObject {
   Object objects[];
} sbo;

layout(location = 0) in vec3 inPosition;
layout(location = 1) in vec3 inColor;
layout(location = 2) in vec2 inTexCoord;
layout(location = 3) in uint obj_index;

layout(location = 0) out vec3 fragColor;
layout(location = 1) out vec2 fragTexCoord;

void main() {
   fragColor = inColor;
   fragTexCoord = inTexCoord;

   gl_Position = ubo.proj * ubo.view * sbo.objects[obj_index].model * vec4(inPosition, 1.0);
}
