package com.medievaltech.advancewars;

import java.io.*;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.Window;

import com.medievaltech.advancewars.Enum.*;

public class Game extends Activity {
	
    /**
     * Invoked during init to give the Activity a chance to set up its Menu.
     * 
     * @param menu the Menu to which entries may be added
     * @return true
     */
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);

        menu.add(0, MenuOption.END_TURN.ordinal(), 0, R.string.menu_end_turn);
        menu.add(0, MenuOption.SAVE.ordinal(), 0, R.string.menu_save);
        menu.add(0, MenuOption.MAIN.ordinal(), 0, R.string.menu_main);
        menu.add(0, MenuOption.EXIT.ordinal(), 0, R.string.menu_exit);
        return true;
    }

    /**
     * Invoked when the user selects an item from the Menu.
     * 
     * @param item the Menu entry which was selected
     * @return true if the Menu item was legit (and we consumed it), false
     *         otherwise
     */
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int i = item.getItemId();
    	
        if(i == MenuOption.END_TURN.ordinal()) {
        	Static.turn = Turn.ENEMY_TURN;
        }else if(i == MenuOption.SAVE.ordinal()) {
    		try {
    			PrintWriter p = new PrintWriter(new FileWriter(android.os.Environment.getExternalStorageDirectory()+"/save.txt"));
    			Static.map.save(p);
    			p.close();
    		}catch(IOException ioe) {
    			ioe.printStackTrace();
    		}
    	}else if(i == MenuOption.MAIN.ordinal()) {
    		Static.gameState = GameState.MAIN_MENU;
    	}else if(i == MenuOption.EXIT.ordinal()) {
    		finish();
        }

        return true;
    }

    /**
     * Invoked when the Activity is created.
     * 
     * @param savedInstanceState a Bundle containing state saved from a previous
     *        execution, or null if this is a new execution
     */
    @Override
    protected void onCreate(Bundle savedInstanceState) {
    	Log.w("AdvanceWars", "We're inside onCreate");
    	
        super.onCreate(savedInstanceState);
        
        Log.w("AdvanceWars", "the super constructor was called successfully");

        // turn off the window's title bar
        requestWindowFeature(Window.FEATURE_NO_TITLE);

        // tell system to use the layout defined in our XML file
        setContentView(R.layout.main);

        Static.game = this;

        if (savedInstanceState == null) {	// we were just launched: set up a new game
        	Log.w("AdvanceWars", "SIS is null");
        } else {
            Log.w("AdvanceWars", "SIS is nonnull");
            
            Static.gameState = (GameState)savedInstanceState.getSerializable("gameState");
        }
    }

    /**
     * Notification that something is about to happen, to give the Activity a
     * chance to save state.
     * 
     * @param outState a Bundle into which this Activity should save its state
     */
    @Override
    protected void onSaveInstanceState(Bundle outState) {
    	outState.putSerializable("gameState", Static.gameState);
    	
        super.onSaveInstanceState(outState);
        Log.w("AdvanceWars", "onSaveInstanceState called");
    }
    
    @Override
    protected void onStop() {
    	System.exit(1);
    	super.onStop();
    }
}