package com.medievaltech.unit;

import java.util.List;

import android.graphics.Point;

import com.medievaltech.advancewars.Player;
import com.medievaltech.advancewars.Static;
import com.medievaltech.advancewars.Tile;
import com.medievaltech.advancewars.Enum.*;

public class Soldier extends Unit{
	public Soldier(Player p) 
	{
		super(p);
		
		move = 3;
		
		type = UnitType.LAND;
		minAttackRange = 1;
		maxAttackRange = 1;
	}
	
	@Override
	public void move(Point point) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void attack(Point point) {
		Tile t = Static.map.getTile(point);
		
		if(t.currentUnit == null && t.currentBuilding != null) {
			t.currentBuilding.currentHealth -= this.currentHealth;
			
			if(t.currentBuilding.currentHealth <= 0) {
				t.currentBuilding.owner = this.owner;
				t.currentBuilding.currentHealth = t.currentBuilding.maxHealth;
			}
		}
	}

	@Override
	public List<Point> getMovementRange() {
		return super.getMovementRange();
	}

	@Override
	public void die() 
	{
		
	}

	@Override
	public List<Point> getAttackRange() {
		// TODO Auto-generated method stub
		return null;
	}
	

}
