package com.medievaltech.advancewars;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;

import com.medievaltech.unit.*;
import com.medievaltech.advancewars.Enum.*;

public class Tile {
	TerrainType type;
	public double moveCoefficent;
	public Unit currentUnit;
	public City currentBuilding;
	public Point point;
	private Paint p;
	
	public Tile(Paint p, TerrainType type) {
		this.p = p;
		this.type = type;
		this.currentUnit = null;
		this.currentBuilding = null;
	}
	
	public Tile(Tile t, Point point) {
		this.type = t.type;
		this.moveCoefficent = t.moveCoefficent;
		this.p = t.p;
		this.point = point;
	}
	
	public void addUnit(Unit unit) {
		currentUnit = unit;
		unit.location = point;
	}
	
	public void removeUnit() {
		if(currentUnit != null) {
			currentUnit = null;
		}
	
	}
	
	public void addBuilding(City c) {
		currentBuilding = c;
		c.location = point;
	}
	
	public void draw(Canvas c, int x, int y) {
		c.drawRect(x, y, x+50, y+50, p);
	}
	
	public void drawUnit(Canvas c, int x, int y) {
		if(currentUnit != null)
			currentUnit.draw(c, x+25, y+25);
	}
	
	public void drawBuilding(Canvas c, int x, int y) {
		if(currentBuilding != null)
			currentBuilding.draw(c, x+25, y+25);
	}
}