package com.medievaltech.advancewars;

import java.io.*;

import android.graphics.*;

import com.medievaltech.unit.Unit;

public class Map {
	private Tile[][] grid;
	public Point offset;
	
	public Map(int width, int height, Point offset) {
		grid = new Tile[width][height];
		this.offset = offset;
	}
	
	public Map(Tile t, int width, int height, Point offset) {
		grid = new Tile[width][height];
		this.offset = offset;
		
		for(int x=0; x<getWidth(); x++)
			for(int y=0; y<getHeight(); y++)
				grid[x][y] = new Tile(t, new Point(x, y));
	}
	
	public int getWidth() {
		return grid.length;
	}
	
	public int getHeight() {
		return grid[0].length;
	}
	
	public Tile getTile(int x, int y) {
		return grid[x][y];
	}
	
	public Tile getTile(Point point) {
		return grid[point.x][point.y];
	}
	
	public void setTile(int x, int y, Tile t) {
		grid[x][y] = t;
	}
	
	public void save(PrintWriter p) {
		p.println(getWidth());
		p.println(getHeight());
		p.println(offset.x+"x"+offset.y);
		
		for(int x=0; x<getWidth(); x++) {
			p.print(grid[x][0].type.ordinal());
			for(int y=1; y<getHeight(); y++)
				p.print(","+grid[x][y].type.ordinal());
			p.println();
		}
		
		for(int x=0; x<getWidth(); x++) {
			for(int y=1; y<getHeight(); y++) {
				if(grid[x][y].currentUnit != null) {
					Unit u = grid[x][y].currentUnit;
					//p.println(u.type);
					//we also need to save the owner of the unit
					p.println(u.location.x+","+u.location.y);
				}
			}
		}
	}
	
	public void draw(Canvas c) {
		for(int x=0; x<getWidth(); x++)
			for(int y=0; y<getHeight(); y++)
				grid[x][y].draw(c, offset.x+50*x, offset.y+50*y);
	}
	
	public void drawUnits(Canvas c) {
		for(int x=0; x<getWidth(); x++)
			for(int y=0; y<getHeight(); y++)
				grid[x][y].drawUnit(c, offset.x+50*x, offset.y+50*y);
	}
	
	public void drawBuildings(Canvas c) {
		for(int x=0; x<getWidth(); x++)
			for(int y=0; y<getHeight(); y++)
				grid[x][y].drawBuilding(c, offset.x+50*x, offset.y+50*y);
	}
}
