#ifndef _GRAPHICS_PIPELINE_OPENGL_H
#define _GRAPHICS_PIPELINE_OPENGL_H

#include <GL/glew.h>

#include "graphics-pipeline.hpp"

class GraphicsPipeline_OpenGL : public GraphicsPipeline {
   public:
      GraphicsPipeline_OpenGL();
      ~GraphicsPipeline_OpenGL();

      void createPipeline(string vertShaderFile, string fragShaderFile);

   private:
      GLuint shaderProgram;
      GLuint vao;
      unsigned int numPoints;

      GLuint loadShaderProgram(string vertShaderFile, string fragShaderFile);
      GLuint loadShader(GLenum type, string file);
};

#endif // _GRAPHICS_PIPELINE_OPENGL_H