#include "graphics-pipeline_opengl.hpp"

#include <iostream>
#include <fstream>

using namespace std;

GraphicsPipeline_OpenGL::GraphicsPipeline_OpenGL() {
}

GraphicsPipeline_OpenGL::~GraphicsPipeline_OpenGL() {
}

void GraphicsPipeline_OpenGL::createPipeline(string vertShaderFile, string fragShaderFile) {
   shaderProgram = loadShaderProgram(vertShaderFile, fragShaderFile);

   glGenVertexArrays(1, &vao);
   numPoints = 0;
}

GLuint GraphicsPipeline_OpenGL::loadShaderProgram(string vertShaderFile, string fragShaderFile) {
   GLuint vs = loadShader(GL_VERTEX_SHADER, vertShaderFile);
   GLuint fs = loadShader(GL_FRAGMENT_SHADER, fragShaderFile);

   GLuint shader_program = glCreateProgram();
   glAttachShader(shader_program, vs);
   glAttachShader(shader_program, fs);

   glLinkProgram(shader_program);

   return shader_program;
}

GLuint GraphicsPipeline_OpenGL::loadShader(GLenum type, string file) {
   cout << "Loading shader from file " << file << endl;

   ifstream shaderFile(file);
   GLuint shaderId = 0;

   if (shaderFile.is_open()) {
      string line, shaderString;

      while (getline(shaderFile, line)) {
         shaderString += line + "\n";
      }
      shaderFile.close();
      const char* shaderCString = shaderString.c_str();

      shaderId = glCreateShader(type);
      glShaderSource(shaderId, 1, &shaderCString, NULL);
      glCompileShader(shaderId);

      cout << "Loaded successfully" << endl;
   }
   else {
      cout << "Failed to load the file" << endl;
   }

   return shaderId;
}