#version 410

#define MAX_NUM_OBJECTS 1024

uniform mat4 view, proj;

layout (std140) uniform models {
  mat4 model_mats[MAX_NUM_OBJECTS];
};

layout(location = 0) in vec3 vertex_position;
layout(location = 1) in vec2 vt;
layout(location = 2) in uint ubo_index;

out vec2 texture_coordinates;
out vec3 position_eye;

void main() {
  position_eye = vec3(view * model_mats[ubo_index] * vec4(vertex_position, 1.0));
  texture_coordinates = vt;

  gl_Position = proj * vec4(position_eye, 1.0);
}