#ifndef _SDL_GAME_H
#define _SDL_GAME_H

#include <vector>

#include <vulkan/vulkan.h>

#include <SDL2/SDL.h>

#include "consts.hpp"

#include "game-gui-sdl.hpp"

using namespace std;

#define VulkanGame NewVulkanGame

#ifdef NDEBUG
   const bool ENABLE_VALIDATION_LAYERS = false;
#else
   const bool ENABLE_VALIDATION_LAYERS = true;
#endif

class VulkanGame {
   public:
      VulkanGame(int maxFramesInFlight);
      ~VulkanGame();

      void run(int width, int height, unsigned char guiFlags); // Mostly example code

   private:
      static VKAPI_ATTR VkBool32 VKAPI_CALL debugCallback(
         VkDebugUtilsMessageSeverityFlagBitsEXT messageSeverity,
         VkDebugUtilsMessageTypeFlagsEXT messageType,
         const VkDebugUtilsMessengerCallbackDataEXT* pCallbackData,
         void* pUserData);

      // TODO: Make these consts static
      // Also, maybe move them into consts.hpp

      const int MAX_FRAMES_IN_FLIGHT; // Unused right now

      // TODO: Good place to start using smart pointers
      GameGui* gui;

      SDL_version sdlVersion;
      SDL_Window* window;

      VkDebugUtilsMessengerEXT debugMessenger = VK_NULL_HANDLE;
      VkSurfaceKHR surface; // TODO: Change the variable name to vulkanSurface
      
      // My code, but not complete. Skips creating the SDL renderer, probably because it doesn't use hardware acceleration.
      // I should try to get uncapped framerate and compare performance w/ and w/out an SDL renderer
      bool initUI(int width, int height, unsigned char guiFlags);
      void initVulkan(); // Mostly example code
      void cleanup(); // Mostly example

      void createVulkanInstance(const vector<const char*>& validationLayers);
      void setupDebugMessenger();
      void populateDebugMessengerCreateInfo(VkDebugUtilsMessengerCreateInfoEXT& createInfo);
      void createVulkanSurface();
      void pickPhysicalDevice(const vector<const char*>& deviceExtensions); // Double-check, but it should be a copy of my code. Still uses g_Instance and g_Physical device though
      bool isDeviceSuitable(VkPhysicalDevice physicalDevice, const vector<const char*>& deviceExtensions);
      void createLogicalDevice(const vector<const char*>& validationLayers,
         const vector<const char*>& deviceExtensions); // Only creates the graphics queue. Later, checks that this queue also supports presenting, but this codebase does not seem to support a separate present queue
};

#endif // _SDL_GAME_H
