package com.example.helloandroid;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.Window;
import android.widget.TextView;
import com.example.helloandroid.GameView.DrawingThread;

public class Game extends Activity {
    private static final int MENU_PAUSE = 1;
    private static final int MENU_RESUME = 2;
    private static final int MENU_START = 3;
    private static final int MENU_STOP = 4;
    private static final int MENU_CONNECT = 5;

    /** A handle to the thread that's actually running the animation. */
    public DrawingThread mThread;

    /** A handle to the View in which the game is running. */
    private GameView mGameView;

    private ClientThread client;
    
    /**
     * Invoked during init to give the Activity a chance to set up its Menu.
     * 
     * @param menu the Menu to which entries may be added
     * @return true
     */
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);

        menu.add(0, MENU_START, 0, R.string.menu_start);
        menu.add(0, MENU_STOP, 0, R.string.menu_stop);
        menu.add(0, MENU_PAUSE, 0, R.string.menu_pause);
        menu.add(0, MENU_RESUME, 0, R.string.menu_resume);
        menu.add(0, MENU_CONNECT, 0, R.string.menu_connect);

        return true;
    }

    /**
     * Invoked when the user selects an item from the Menu.
     * 
     * @param item the Menu entry which was selected
     * @return true if the Menu item was legit (and we consumed it), false
     *         otherwise
     */
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case MENU_START:
            	mThread.doStart();
                return true;
            case MENU_STOP:
            	mThread.setState(DrawingThread.STATE_LOSE, getText(R.string.message_stopped));
                return true;
            case MENU_PAUSE:
            	mThread.pause();
                return true;
            case MENU_RESUME:
            	mThread.unpause();
                return true;
            case MENU_CONNECT:
            	mThread.connectionStarted = true;
                client = new ClientThread("192.168.1.6", 1337, this);
				client.start();
				mThread.doStart();
				return true;
        }

        return false;
    }

    /**
     * Invoked when the Activity is created.
     * 
     * @param savedInstanceState a Bundle containing state saved from a previous
     *        execution, or null if this is a new execution
     */
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        // turn off the window's title bar
        requestWindowFeature(Window.FEATURE_NO_TITLE);

        // tell system to use the layout defined in our XML file
        setContentView(R.layout.main);

        mGameView = (GameView) findViewById(R.id.lunar);
        mThread = mGameView.getThread();

        mGameView.setTextView((TextView) findViewById(R.id.text));

        if (savedInstanceState == null) {
            // we were just launched: set up a new game
        	mThread.setState(DrawingThread.STATE_RUNNING);
            Log.w("Galcon", "SIS is null");
        } else {
            Log.w("Galcon", "SIS is nonnull");
        }
    }

    /**
     * Invoked when the Activity loses user focus.
     */
    @Override
    protected void onPause() {
        super.onPause();
        mGameView.getThread().pause(); // pause game when Activity pauses
    }

    /**
     * Notification that something is about to happen, to give the Activity a
     * chance to save state.
     * 
     * @param outState a Bundle into which this Activity should save its state
     */
    @Override
    protected void onSaveInstanceState(Bundle outState) {
        // just have the View's thread save its state into our Bundle
        super.onSaveInstanceState(outState);
        Log.w("Galcon", "SIS called");
    }
}