import pygame, platform

system = platform.system()

[w, h] = [0, 0]

if system == 'Windows':
   print("Windows detected")

   import ctypes
   user32 = ctypes.windll.user32
   [w, h] = [user32.GetSystemMetrics(0), user32.GetSystemMetrics(1)]
elif system == 'Linux':
   print("Linux detected")
else:
   print("Unknown OS: " + system)

print("Detected native resolution: {:d}x{:d}".format(w, h))

pygame.init()

if w == 0 and h == 0:
   print("Not using fullscreen")
   gameDisplay = pygame.display.set_mode((800, 600))
else:
   gameDisplay = pygame.display.set_mode((w, h), pygame.FULLSCREEN)

pygame.display.set_caption('Space Game')

clock = pygame.time.Clock()

running = True

while running:
   for event in pygame.event.get():
      if event.type == pygame.QUIT:
         running = False
      elif event.type == pygame.KEYDOWN:
         if event.key == pygame.K_ESCAPE:
            running = False

      #print(event)

   pygame.display.update()
   clock.tick(60)

pygame.quit()
print("Game ended")
quit()