#include "vulkan-game.hpp"

#include <iostream>

#include "consts.hpp"
#include "crash-logger.hpp"

using namespace std;

int __main(int argc, char* argv[]);

int main(int argc, char* argv[]) {
   CrashLogger logger(__main, argc, argv);

   exit(0);
}

int __main(int argc, char* argv[]) {

#ifdef NDEBUG
   cout << "DEBUGGING IS OFF" << endl;
#else
   cout << "DEBUGGING IS ON" << endl;
#endif

   cout << "Starting Vulkan Game..." << endl;

   VulkanGame game;

   try {
      game.run(800, 600, GUI_FLAGS_WINDOW_FULLSCREEN);
   } catch (const exception& e) {
      cerr << e.what() << endl;
      return EXIT_FAILURE;
   }

   cout << "Finished running the game" << endl;

   return EXIT_SUCCESS;
}