#ifndef _PANEL_HPP
#define _PANEL_HPP

#include <vector>

#include <SDL2/SDL.h>

#include "../game-gui.hpp"

#include "ui-element.hpp"

// TODO: Allow border color and width to be configurable
class Panel : public UIElement {
public:
   Panel(int x, int y, int width, int height, uint32_t color, SDL_Renderer& renderer);
   ~Panel() override;

   void addUIElement(UIElement* element);

   void render(int x, int y) override;
   void handleEvent(GameEvent& e) override;

private:
   SDL_Texture* texture = nullptr;
   uint32_t color = 0x00000000;

   vector<UIElement*> uiElements;
};

#endif // _PANEL_HPP
