#include "button-imgui.hpp"

#include "../IMGUI/imgui.h"
#include "../IMGUI/imgui_internal.h" // For CalcItemSize

ButtonImGui::ButtonImGui(string label) {
   this->label = label;

   calculateSize();
}

ButtonImGui::~ButtonImGui() {
}

bool ButtonImGui::draw(int offset) {
   ImGui::InvisibleButton("", ImVec2(offset, 18));
   ImGui::SameLine();

   //ImGui::SetCursorPos(int x, int y);
   return ImGui::Button(label.c_str());
}

void ButtonImGui::calculateSize() {
   vec2 labelSize = ImGui::CalcTextSize(label.c_str());
   ImGuiStyle& style = ImGui::GetStyle();

   vec2 size = ImGui::CalcItemSize(vec2(0, 0), labelSize.x + style.FramePadding.x * 2.0f, labelSize.y + style.FramePadding.y * 2.0f);

   width = size.x;
   height = size.y;
}
