# Create graphic pipeline
vertex_input_create = VkPipelineVertexInputStateCreateInfo(
   sType = VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO,
   flags = 0,
   vertexBindingDescriptionCount = 1,
   pVertexBindingDescriptions = buffers.standard.description,
   vertexAttributeDescriptionCount = len(buffers.standard.attributes),
   pVertexAttributeDescriptions = buffers.standard.attributes);

input_assembly_create = VkPipelineInputAssemblyStateCreateInfo(
   sType = VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO,
   flags = 0,
   topology = VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST,
   primitiveRestartEnable = VK_FALSE);
viewport = VkViewport(
   x = 0., y = 0., width = float(self.extent.width), height = float(self.extent.height),
   minDepth = 0., maxDepth = 1.);

scissor_offset = VkOffset2D(x = 0, y = 0);
scissor = VkRect2D(offset = scissor_offset, extent = self.extent);
viewport_state_create = VkPipelineViewportStateCreateInfo(
   sType = VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO,
   flags = 0,
   viewportCount = 1,
   pViewports = [viewport],
   scissorCount = 1,
   pScissors = [scissor]);

rasterizer_create = VkPipelineRasterizationStateCreateInfo(
   sType = VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO,
   flags = 0,
   depthClampEnable = VK_FALSE,
   rasterizerDiscardEnable = VK_FALSE,
   polygonMode = VK_POLYGON_MODE_FILL,
   lineWidth = 1,
   cullMode = VK_CULL_MODE_NONE, #VK_CULL_MODE_BACK_BIT,
   frontFace = VK_FRONT_FACE_COUNTER_CLOCKWISE, #VK_FRONT_FACE_CLOCKWISE,
   depthBiasEnable = VK_FALSE,
   depthBiasConstantFactor = 0.,
   depthBiasClamp = 0.,
   depthBiasSlopeFactor = 0.);

multisample_create = VkPipelineMultisampleStateCreateInfo(
   sType = VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO,
   flags = 0,
   sampleShadingEnable = VK_TRUE,
   rasterizationSamples = 2 * *self.config["multisamplelevel"],
   minSampleShading = 1,
   pSampleMask = None,
   alphaToCoverageEnable = VK_FALSE,
   alphaToOneEnable = VK_FALSE);

color_blend_attachement = VkPipelineColorBlendAttachmentState(
   colorWriteMask = VK_COLOR_COMPONENT_R_BIT | VK_COLOR_COMPONENT_G_BIT | VK_COLOR_COMPONENT_B_BIT | VK_COLOR_COMPONENT_A_BIT,
   blendEnable = VK_FALSE,
   srcColorBlendFactor = VK_BLEND_FACTOR_SRC_COLOR,
   dstColorBlendFactor = VK_BLEND_FACTOR_ONE_MINUS_SRC_COLOR,
   colorBlendOp = VK_BLEND_OP_ADD,
   #srcAlphaBlendFactor = VK_BLEND_FACTOR_ZERO,
   #dstAlphaBlendFactor = VK_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA,
   alphaBlendOp = VK_BLEND_OP_ADD);

color_blend_create = VkPipelineColorBlendStateCreateInfo(
   sType = VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO,
   flags = 0,
   logicOpEnable = VK_FALSE,
   logicOp = VK_LOGIC_OP_COPY,
   attachmentCount = 1,
   pAttachments = [color_blend_attachement],
   blendConstants = [0, 0, 0, 0]);

push_constant_ranges = VkPushConstantRange(
   stageFlags = 0,
   offset = 0,
   size = 0);

samplerlayoutbinding = VkDescriptorSetLayoutBinding(
   binding = 1,
   descriptorCount = 1,
   descriptorType = VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER,
   pImmutableSamplers = None,
   stageFlags = VK_SHADER_STAGE_FRAGMENT_BIT,

   );

layoutbindings = [ubo.descriptor, samplerlayoutbinding];

layoutinfo = VkDescriptorSetLayoutCreateInfo(
   VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO,
   bindingCount = len(layoutbindings),
   pBindings = layoutbindings,

   );
self.descriptorsetlayout = vkCreateDescriptorSetLayout(self.logical_device, layoutinfo, None);



pipeline_layout_create = VkPipelineLayoutCreateInfo(
   sType = VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO,
   flags = 0,
   setLayoutCount = 1,
   pSetLayouts = [self.descriptorsetlayout],
   pushConstantRangeCount = 0,
   pPushConstantRanges = [push_constant_ranges]);

self.pipeline_layout = vkCreatePipelineLayout(self.logical_device, pipeline_layout_create, None);

depthstencil = VkPipelineDepthStencilStateCreateInfo(
   sType = VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO,
   depthTestEnable = VK_TRUE,
   depthWriteEnable = VK_TRUE,
   depthCompareOp = VK_COMPARE_OP_LESS,
   depthBoundsTestEnable = VK_FALSE,
   minDepthBounds = 0,
   maxDepthBounds = 1,
   stencilTestEnable = VK_FALSE,
   );

# Finally create graphic pipeline
pipeline_create = VkGraphicsPipelineCreateInfo(
   sType = VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO,
   flags = 0,
   stageCount = 2,
   pStages = [shaders.shaderlibrary["orthogonal_vert"].pipelinebit, shaders.shaderlibrary["generic_frag"].pipelinebit],
   pVertexInputState = vertex_input_create,
   pInputAssemblyState = input_assembly_create,
   pTessellationState = None,
   pViewportState = viewport_state_create,
   pRasterizationState = rasterizer_create,
   pMultisampleState = multisample_create,
   pDepthStencilState = depthstencil,
   pColorBlendState = color_blend_create,
   pDynamicState = None,
   layout = self.pipeline_layout,
   renderPass = self.render_pass.render_pass,
   subpass = 0,
   basePipelineHandle = None,
   basePipelineIndex = -1);

self.pipeline = vkCreateGraphicsPipelines(self.logical_device, None, 1, [pipeline_create], None);