#include "game-gui-sdl.hpp"

#include <map>
#include <queue>

#include "consts.hpp"

map<unsigned int, unsigned char> s_keyState;
map<unsigned int, bool> s_keyDown;

using namespace std;

/*
// Temporary to allow the program using this class to receive events other than keyboard events
// Remove once I add a better game-gui wrapper for doing that
queue<SDL_Event> events;

queue<MouseEvent> mouseEvents;
*/

string GameGui_SDL::s_errorMessage;

string& GameGui_SDL::getError() {
   GameGui_SDL::s_errorMessage = SDL_GetError();

   return GameGui_SDL::s_errorMessage;
}

bool GameGui_SDL::init() {
   // may want to define SDL_INIT_NOPARACHUTE when I start handling crashes since it
   // prevents SDL from setting up its own handlers for SIG_SEGV and stuff like that

   GameGui_SDL::s_errorMessage = "No error";

   if (SDL_Init(SDL_INIT_EVERYTHING) < 0) {
      return RTWO_ERROR;
   }

   int imgFlags = IMG_INIT_PNG;
   if (!(IMG_Init(imgFlags) & imgFlags)) {
      return RTWO_ERROR;
   }

   if (TTF_Init() == -1) {
      return RTWO_ERROR;
   }

   return RTWO_SUCCESS;
}

void GameGui_SDL::shutdown() {
   SDL_Quit();
}

void* GameGui_SDL::createWindow(const string& title, int width, int height, bool fullscreen) {
   // TODO: Make an OpenGL version of the SDL_CreateWindow call as well

   // On Apple's OS X you must set the NSHighResolutionCapable Info.plist property to YES,
   // otherwise you will not receive a High DPI OpenGL canvas.

   uint32_t flags = SDL_WINDOW_VULKAN;

   flags |= fullscreen ? SDL_WINDOW_FULLSCREEN_DESKTOP : SDL_WINDOW_RESIZABLE;

   window = SDL_CreateWindow(title.c_str(),
               SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED,
               width, height, flags);

   return window;
}

void GameGui_SDL::destroyWindow() {
   // TODO: This function can throw some errors. They should be handled
   SDL_DestroyWindow(window);
}

/*
void GameGui_SDL::processEvents() {
   SDL_Event e;

   s_keyState.clear();
   while (SDL_PollEvent(&e)) {
      if (e.type == SDL_KEYDOWN || e.type == SDL_KEYUP) {
         if (e.type == SDL_KEYDOWN && !e.key.repeat) {
            s_keyState[e.key.keysym.sym] = RTWO_KEY_EVENT_PRESSED;
         } else if (e.type == SDL_KEYUP) {
            s_keyState[e.key.keysym.sym] = RTWO_KEY_EVENT_RELEASED;
         } else {
            s_keyState.erase(e.key.keysym.sym);
         }

         s_keyDown[e.key.keysym.sym] = e.type == SDL_KEYDOWN;
      } else if (e.type == SDL_MOUSEBUTTONDOWN || e.type == SDL_MOUSEBUTTONUP) {
         MouseEvent mouseEvent { 0, 0, e.button.x, e.button.y };

         mouseEvents.push(mouseEvent);
      } else {
         events.push(e);
      }
   }
}

int GameGui_SDL::pollMouseEvent(MouseEvent* event) {
   if (mouseEvents.empty()) {
      return 0;
   }

   *event = mouseEvents.front();
   mouseEvents.pop();

   return 1;
}

unsigned char GameGui_SDL::getKeyEvent(unsigned int key) {
   if (s_keyDown.count(key)) {
      return s_keyState[key];
   } else {
      return RTWO_KEY_EVENT_NONE;
   }
}

bool GameGui_SDL::isKeyPressed(unsigned int key) {
   if (s_keyDown.count(key)) {
      return s_keyDown[key];
   } else {
      return false;
   }
}

int GameGui_SDL::pollEvent(SDL_Event* event) {
   if (events.empty()) {
      return 0;
   }

   *event = events.front();
   events.pop();

   return 1;
}
*/

#ifdef GAMEGUI_INCLUDE_VULKAN

bool GameGui_SDL::createVulkanSurface(VkInstance instance, VkSurfaceKHR* surface) {
   return SDL_Vulkan_CreateSurface(window, instance, surface) ?
      RTWO_SUCCESS : RTWO_ERROR;
}

#endif

vector<const char*> GameGui_SDL::getRequiredExtensions() {
   uint32_t extensionCount = 0;
   SDL_Vulkan_GetInstanceExtensions(window, &extensionCount, nullptr);

   vector<const char*> extensions(extensionCount);
   SDL_Vulkan_GetInstanceExtensions(window, &extensionCount, extensions.data());

   return extensions;
}

void GameGui_SDL::getWindowSize(int* width, int* height) {
   SDL_GetWindowSize(window, width, height);
}
