package com.example.gui;

import android.graphics.Canvas;
import android.graphics.Paint;

public class Text extends GUIObject {
	private String text;
	private Paint textPaint;
	private float vOffset;
	
	public Text(String newText, int newX, int newY, int newWidth, int newHeight, Paint textPaint) {
		super(newX, newY, newWidth, newHeight, null);
		
		this.textPaint = textPaint;
		text = newText;	
		vOffset = -(textPaint.getFontMetrics().ascent+textPaint.getFontMetrics().descent)/2;
	}
	
	public void draw(Canvas c) {
		c.drawText(text, x+width/2, y+height/2+vOffset, textPaint);
	} 
}