#include "vulkan-game.hpp"

#include <iostream>

#include "consts.hpp"

#define GAMEGUI_INCLUDE_VULKAN
#include "game-gui-sdl.hpp"

using namespace std;

VulkanGame::VulkanGame() {
   gui = nullptr;
   window = nullptr;
}

VulkanGame::~VulkanGame() {
}

void VulkanGame::run(unsigned int width, unsigned int height, unsigned char guiFlags) {
   if (initWindow(width, height, guiFlags) == RTWO_ERROR) {
      return;
   }
   initVulkan();
   mainLoop();
   cleanup();
}

bool VulkanGame::initWindow(unsigned int width, unsigned int height, unsigned char guiFlags) {
   gui = new GameGui_SDL();

   if (gui->Init() == RTWO_ERROR) {
      cout << "UI library could not be initialized!" << endl;
      cout << gui->GetError() << endl;
      return RTWO_ERROR;
   }
   cout << "GUI init succeeded" << endl;

   window = (SDL_Window*) gui->CreateWindow("Vulkan Game", width, height, guiFlags | GUI_FLAGS_WINDOW_FULLSCREEN);
   if (window == nullptr) {
      cout << "Window could not be created!" << endl;
      return RTWO_ERROR;
   }

   return RTWO_SUCCESS;
}

void VulkanGame::initVulkan() {
}

void VulkanGame::mainLoop() {
   SDL_Event e;
   bool quit = false;

   while (!quit) {
      while (SDL_PollEvent(&e)) {
         if (e.type == SDL_QUIT) {
            quit = true;
         }
         if (e.type == SDL_KEYDOWN) {
            quit = true;
         }
         if (e.type == SDL_MOUSEBUTTONDOWN) {
            quit = true;
         }
      }
   }
}

void VulkanGame::cleanup() {
   gui->DestroyWindow();
   gui->Shutdown();
   delete gui;
}