#ifndef _GAME_GUI_H
#define _GAME_GUI_H

#include <string>
#include <vector>

#ifdef GAMEGUI_INCLUDE_VULKAN
   #include <vulkan/vulkan.h>
#endif

// TODO: Remove the line below once the couts in the game-gui-* files are moved
#include <iostream>

using namespace std;

class GameGui {
   public:
      virtual ~GameGui() {};

      virtual string& GetError() = 0;

      virtual bool Init() = 0;
      virtual void Shutdown() = 0;

      virtual void* CreateWindow(const string& title, unsigned int width, unsigned int height, bool fullscreen) = 0;
      virtual void DestroyWindow() = 0;

#ifdef GAMEGUI_INCLUDE_VULKAN
      virtual bool CreateVulkanSurface(VkInstance instance, VkSurfaceKHR* surface) = 0;
#endif

      virtual vector<const char*> GetRequiredExtensions() = 0;
      virtual void GetWindowSize(int* width, int* height) = 0;
};

#endif // _GAME_GUI_H