#ifndef _GAME_GUI_GLFW_H
#define _GAME_GUI_GLFW_H

#include "game-gui.hpp"

#ifdef GAMEGUI_INCLUDE_VULKAN
   #define GLFW_INCLUDE_VULKAN
#endif

#include <GLFW/glfw3.h>

#define NUM_KEYS (512)

class GameGui_GLFW : public GameGui {
   public:
      static string s_errorMessage; // Has to be public so that glfw_error_callback can access it

      // Both have to be public so that glfw_key_callback can access them
      // TODO: Implement a more generic public api over this to get the key state
      static int s_keyState[NUM_KEYS];
      static bool s_keyDown[NUM_KEYS];

      string& GetError();

      bool Init();
      void Shutdown();

      void* CreateWindow(const string& title, unsigned int width, unsigned int height, bool fullscreen);
      void DestroyWindow();

#ifdef GAMEGUI_INCLUDE_VULKAN
      bool CreateVulkanSurface(VkInstance instance, VkSurfaceKHR* surface);
#endif

      vector<const char*> GetRequiredExtensions();
      void GetWindowSize(int* width, int* height);

   private:
      GLFWwindow* window;
};

void glfw_error_callback(int error, const char* description);
void glfw_key_callback(GLFWwindow* window, int key, int scancode, int action, int mods);

#endif // _GAME_GUI_GLFW_H