#include "panel.hpp"

#include <iostream>

// #include <SDL2/SDL2_gfxPrimitives.h>

using namespace std;

Panel::Panel(int x, int y, int width, int height, uint32_t color, SDL_Renderer& renderer) :
      UIElement {x, y, width, height, renderer, nullptr, nullptr, nullptr},
      color(color) {
   this->texture = SDL_CreateTexture(&this->renderer, SDL_PIXELFORMAT_RGBA8888,
      SDL_TEXTUREACCESS_TARGET, this->width, this->height);
   if (this->texture == nullptr) {
      cout << "Unable to create texture! SDL Error: " << SDL_GetError() << endl;
   }
}

Panel::~Panel() {
   for (UIElement*& uiElement : this->uiElements) {
      delete uiElement;
   }

   if (this->texture != nullptr) {
      SDL_DestroyTexture(this->texture);
      this->texture = nullptr;
   }
}

void Panel::addUIElement(UIElement* element) {
   this->uiElements.push_back(element);
}

void Panel::render(int x, int y) {
   SDL_Texture* renderTarget = SDL_GetRenderTarget(&this->renderer);

   SDL_SetRenderTarget(&this->renderer, this->texture);

   // clear the texture
   SDL_SetRenderDrawBlendMode(&this->renderer, SDL_BLENDMODE_NONE);
   SDL_SetRenderDrawColor(&this->renderer, 0x00, 0x00, 0x00, 0x00);
   SDL_RenderClear(&this->renderer);

   /*
   roundedBoxRGBA(&this->renderer, 0, 0, this->width, this->height,
      8, 0x33, 0x33, 0x33, 0xFF);
   */

   int borderThickness = 1;

   uint8_t colorR = (this->color >> 24) & 0xFF;
   uint8_t colorG = (this->color >> 16) & 0xFF;
   uint8_t colorB = (this->color >> 8) & 0xFF;
   uint8_t colorA = this->color & 0xFF;

   /*
   roundedBoxRGBA(&this->renderer, borderThickness, borderThickness,
      this->width - borderThickness, this->height - borderThickness,
      8, colorR, colorG, colorB, colorA);
   */

   for (UIElement*& uiElement : this->uiElements) {
      uiElement->render(7, 7);
   }
   
   SDL_SetRenderTarget(&this->renderer, renderTarget);
   SDL_SetTextureBlendMode(this->texture, SDL_BLENDMODE_BLEND);

   SDL_Rect rect = { this->x + x, this->y + y, this->width, this->height };

   SDL_RenderCopy(&this->renderer, this->texture, nullptr, &rect);
}

void Panel::handleEvent(GameEvent& e) {
   for (UIElement*& uiElement : this->uiElements) {
      uiElement->handleEvent(e);
   }
}