package com.example.helloandroid;

import java.math.*;

public class Fleet {
	private int x;
	private int y;
	private double slope, xIntercept; 
	private double direction;
	private Planet destination;
	private int numShips;
	private int faction;
	
	/* Optimising: pre-calculate paths */
	public Fleet(Planet source, Planet destination, int numShips, int faction) {
		//Calculate initial coordinates and direction 
		if(destination.getX() - source.getX() != 0){
		//line formula 
		slope = ((source.getY() - destination.getY())/(source.getX() - destination.getX()));
		xIntercept = destination.getY() - (slope*destination.getX());
		
		//direction
		direction = 1/Math.tan(slope);
		
		//coordinates for all 4 coordinates
		if(destination.getX() - source.getX() < 0 )
			direction += Math.PI;
		
		x = (int)((Math.cos(direction)*(source.radius + 10) + source.getX()));
		y = (int)((Math.sin(direction)*(source.radius + 10) + source.getY()));
		} else {
			if((destination.getY() - source.getY()) > 0 ){
				direction = Math.PI/2;
				x = destination.getX();
				y = source.getY() + source.radius + 10;
			} else {
				direction = 3*Math.PI/2;
				x = destination.getX();
				y = source.getY() - source.radius - 10;
			}
		}
		
		this.numShips = numShips;
		this.faction = faction;
		this.destination = destination;
	}
	
		
	public int getX() {
		return x;
	}



	public void setX(int x) {
		this.x = x;
	}



	public int getY() {
		return y;
	}



	public void setY(int y) {
		this.y = y;
	}



	public double getDirection() {
		return direction;
	}



	public void setDirection(double direction) {
		this.direction = direction;
	}



	public Planet getDestination() {
		return destination;
	}



	public void setDestination(Planet destination) {
		this.destination = destination;
	}



	public int getNumShips() {
		return numShips;
	}



	public void setNumShips(int numShips) {
		this.numShips = numShips;
	}



	public int getFaction() {
		return faction;
	}



	public void setFaction(int faction) {
		this.faction = faction;
	}



	public void update() {
		
	}
	
	// attack the destination planet
	public void attack() {
		if(numShips <= destination.getNumShips()){
			destination.setNumShips(destination.getNumShips() - numShips);
		} else {
			destination.setNumShips(numShips - destination.getNumShips());
			destination.setFaction(this.faction);
		}
	}
}
