package com.example.helloandroid;

import java.util.ArrayList;

public class Planet {
	int radius;
	int regenRate;	// ships per second
	private int x;
	private int y;
	int faction;
	int numShips;

	public Planet(int radius, int x, int y) {
		this.radius = radius;
		this.x = x;
		this.y = y;
		faction = 0;
		numShips = 0;
		
		regenRate = 0;	//change this to some expression / funcion call
	}
	
	public int getX() {
		return x;
	}
	
	public int getY() {
		return y;
	}
	
	public int getRadius() {
		return radius;
	}
	
	public int getNumShips() {
		return numShips;
	}
	
	public void setNumShips(int num) {
		numShips = num;
	}
	
	public void setFaction(int faction) {
		this.faction = faction;
	}
	
	public void update() {
		//regen ships if not owned by faction 0
		numShips++;
	}
	
	public void sendFleet(Planet p, int numShips) {
		
	}
	
	public boolean collides(Planet p) {
		double dist = Math.sqrt(Math.pow(this.x-p.x, 2) + Math.pow(this.y-p.y, 2));
		
		return dist <= this.radius + p.radius;
	}
	
	public static boolean collisionDetected(Planet p, ArrayList<Planet> curPlanets) {
		for(Planet p2 : curPlanets) {
			if(p.collides(p2))
				return true;
		}
		
		return false;
	}
}
