package com.medievaltech.advancewars;

import com.medievaltech.unit.Unit;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;

public class Tile {
	public enum TerrainType
	{
		LAND, SEA
	}
	
	TerrainType type;
	public double moveCoefficent;
	public Unit currentUnit;
	public Point point;
	private Paint p;
	
	public Tile(Paint p, TerrainType type) {
		this.p = p;
		this.type = type;
		this.currentUnit = null;
	}
	
	public Tile(Tile t, Point point) {
		this.type = t.type;
		this.moveCoefficent = t.moveCoefficent;
		this.p = t.p;
		this.point = point;
	}
	
	public void addUnit(Unit unit) {
		currentUnit = unit;
		unit.location = point;
	}
	
	public void removeUnit(Unit unit) {
		if(currentUnit != null) {
			currentUnit = null;
		}
	
	}
	
	public void draw(Canvas c, int x, int y) {
		c.drawRect(x, y, x+50, y+50, p);
	}
	
	public void drawUnit(Canvas c, int x, int y) {
		if(currentUnit != null)
			currentUnit.draw(c, x+25, y+25);
	}
}