package com.medievaltech.advancewars;

import java.io.*;

import com.medievaltech.advancewars.GameView.DrawingThread;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.Window;
import android.widget.TextView;

public class Game extends Activity {
	private static final int MENU_SAVE = 1;
	private static final int MENU_MAIN = 2;
    private static final int MENU_EXIT = 3;
    
    public enum State{BUST, ACTIVE, DOUBLEDOWN};

    /** A handle to the thread that's actually running the animation. */
    public DrawingThread mThread;

    /** A handle to the View in which the game is running. */
    private GameView mGameView;
    
    /**
     * Invoked during init to give the Activity a chance to set up its Menu.
     * 
     * @param menu the Menu to which entries may be added
     * @return true
     */
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);

        menu.add(0, MENU_SAVE, 0, R.string.menu_save);
        menu.add(0, MENU_MAIN, 0, R.string.menu_main);
        menu.add(0, MENU_EXIT, 0, R.string.menu_exit);
        return true;
    }

    /**
     * Invoked when the user selects an item from the Menu.
     * 
     * @param item the Menu entry which was selected
     * @return true if the Menu item was legit (and we consumed it), false
     *         otherwise
     */
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
        	case MENU_SAVE:
        		try {
        			PrintWriter p = new PrintWriter(new FileWriter(android.os.Environment.getExternalStorageDirectory()+"/save.txt"));
        			mThread.mMap.save(p);
        			p.close();
        		}catch(IOException ioe) {
        			ioe.printStackTrace();
        		}
    			break;
        	case MENU_MAIN:
        		mThread.mGameState = GameState.MAIN_MENU;
        		break;
            case MENU_EXIT:
            	finish();
            	break;
        }

        return true;
    }

    /**
     * Invoked when the Activity is created.
     * 
     * @param savedInstanceState a Bundle containing state saved from a previous
     *        execution, or null if this is a new execution
     */
    @Override
    protected void onCreate(Bundle savedInstanceState) {
    	Log.w("AdvanceWars", "We're inside onCreate");
    	
        super.onCreate(savedInstanceState);
        
        Log.w("AdvanceWars", "the super constructor was called successfully");

        // turn off the window's title bar
        requestWindowFeature(Window.FEATURE_NO_TITLE);

        // tell system to use the layout defined in our XML file
        setContentView(R.layout.main);

        mGameView = (GameView) findViewById(R.id.lunar);
        mThread = mGameView.getThread();
        mGameView.mGame = this;

        mGameView.setTextView((TextView) findViewById(R.id.text));

        if (savedInstanceState == null) {	// we were just launched: set up a new game
        	Log.w("AdvanceWars", "SIS is null");
        	
        	mThread.setState(AppState.RUNNING);
        } else {
            Log.w("AdvanceWars", "SIS is nonnull");
            
            mThread.setState(AppState.RUNNING);
            
            mGameView.getThread().mGameState = (GameState)savedInstanceState.getSerializable("gameState");
        }
    }

    /**
     * Invoked when the Activity loses user focus.
     */
    @Override
    protected void onPause() {
        super.onPause();
        mGameView.getThread().pause(); // pause game when Activity pauses
    }

    /**
     * Notification that something is about to happen, to give the Activity a
     * chance to save state.
     * 
     * @param outState a Bundle into which this Activity should save its state
     */
    @Override
    protected void onSaveInstanceState(Bundle outState) {
    	outState.putSerializable("gameState", mGameView.getThread().mGameState);
    	
        super.onSaveInstanceState(outState);
        Log.w("AdvanceWars", "onSaveInstanceState called");
    }
    
    @Override
    protected void onStop() {
    	System.exit(1);
    	super.onStop();
    }
}