#ifndef _GAME_GUI_H
#define _GAME_GUI_H

#include <vulkan/vulkan.h>

#include <string>

using namespace std;

#define RTWO_SUCCESS true
#define RTWO_ERROR false

class GameGui {
   public:
      virtual ~GameGui() {};

      virtual bool Init() = 0;
      virtual void Shutdown() = 0;

      virtual void* CreateWindow(const string& title, unsigned int width, unsigned int height) = 0;
      virtual void DestroyWindow() = 0;

      virtual bool CreateVulkanSurface(VkInstance instance, VkSurfaceKHR* surface) = 0; 
};

#endif // _GAME_GUI_H