#include "space-game.hpp"

#include <iostream>

#include "game-gui-sdl.hpp"

using namespace std;

SpaceGame::SpaceGame() {
   gui = nullptr;
   window = nullptr;
}

SpaceGame::~SpaceGame() {
}

void SpaceGame::run() {
   if (initWindow() == RTWO_ERROR) {
      return;
   }
   initVulkan();
   mainLoop();
   cleanup();
}

bool SpaceGame::initWindow() {
   gui = new GameGui_SDL();

   if (gui->Init() == RTWO_ERROR) {
      cout << "UI library could not be initialized!" << endl;
      cout << SDL_GetError() << endl;
      return RTWO_ERROR;
   }
   cout << "GUI init succeeded" << endl;

   window = (SDL_Window*) gui->CreateWindow("Vulkan Game", SCREEN_WIDTH, SCREEN_HEIGHT);
   if (window == nullptr) {
      cout << "Window could not be created!" << endl;
      return RTWO_ERROR;
   }

   return RTWO_SUCCESS;
}

void SpaceGame::initVulkan() {
}

void SpaceGame::mainLoop() {
   SDL_Event e;
   bool quit = false;

   while (!quit) {
      while (SDL_PollEvent(&e)) {
         if (e.type == SDL_QUIT) {
            quit = true;
         }
         if (e.type == SDL_KEYDOWN) {
            quit = true;
         }
         if (e.type == SDL_MOUSEBUTTONDOWN) {
            quit = true;
         }
      }
   }
}

void SpaceGame::cleanup() {
   gui->DestroyWindow();
   gui->Shutdown();
   delete gui;
}