#include "game-gui-glfw.hpp"

bool GameGui_GLFW::Init() {
   return glfwInit() == GLFW_TRUE ? RTWO_SUCCESS : RTWO_SUCCESS;
}

void GameGui_GLFW::Shutdown() {
   glfwTerminate();
}

void* GameGui_GLFW::CreateWindow(const string& title, unsigned int width, unsigned int height) {
   glfwWindowHint(GLFW_CLIENT_API, GLFW_NO_API);

   window = glfwCreateWindow(width, height, title.c_str(), nullptr, nullptr);

   return window;
}

void GameGui_GLFW::DestroyWindow() {
   // TODO: This function can throw some errors. They should be handled
   glfwDestroyWindow(window);
}

bool GameGui_GLFW::CreateVulkanSurface(VkInstance instance, VkSurfaceKHR* surface) {
   return glfwCreateWindowSurface(instance, window, nullptr, surface) == VK_SUCCESS ?
      RTWO_SUCCESS : RTWO_ERROR;
}

vector<const char*> GameGui_GLFW::GetRequiredExtensions() {
   uint32_t glfwExtensionCount = 0;
   const char** glfwExtensions;

   glfwExtensions = glfwGetRequiredInstanceExtensions(&glfwExtensionCount);

   vector<const char*> extensions(glfwExtensions, glfwExtensions + glfwExtensionCount);

   return extensions;
}

void GameGui_GLFW::GetWindowSize(int* width, int* height) {
   glfwGetFramebufferSize(window, width, height);
}
