import javax.swing.JOptionPane;


public class PortalThread extends Connection {
	private LostHavenPortal main;

    public PortalThread(String ip, int port, LostHavenPortal main) {
    	super(ip, port, "PortalThread");
    	
		this.main = main;
    }
    
    protected void processMessage(MessageType type, String input) {
    	Player p;
        int id;
        String name;
        boolean online;

    	switch(type) {
    	case Info:
    		if(input.equals("started")) {
    			main.lblServerStatus.setText("online");
    		}else if(input.equals("stopped")) {
    			main.lblServerStatus.setText("offline");
    		}
    		break;
    	case Registered:
    		id = Integer.parseInt(input.substring(0, input.indexOf(";")));
    		input = input.substring(input.indexOf(";")+1);
    		name = input.substring(0, input.indexOf(";"));
    		input = input.substring(input.indexOf(";")+1);
    		online = input.equals("true");
    		
    		p = new Player(id, name, "");
    		
    		if(!main.registered.containsKey(name)) {
    			main.addRegList(name, p);
    			if(online) {
    				main.addOnlineList(name);
    			}
    		}
    		break;
    	}
    }
    
    protected void connectionStart() {
    	
    }
    
    protected void connectionSuccess() {
    	main.lblConnectionStatus.setText("connected");
		sendMessage(MessageType.Admin, "");
    }
    
    protected void connectionFailure() {
    	JOptionPane.showMessageDialog(main, "Connection could not be established.");
    }
    
    protected void connectionBreak() {
    	JOptionPane.showMessageDialog(main, "Your connection was interrupted");
    }
    
    protected void peerDisconnect() {
    	JOptionPane.showMessageDialog(main, "The server disconnected");
    }
    
    protected void connectionEnd() {
    	main.registered.clear();
    	main.orderedReg.clear();
    	main.orderedOnline.clear();
    	main.lblConnectionStatus.setText("disconnected");
    	main.lblServerStatus.setText("not available");
    	main.updateGui();
    }
}
