#ifndef _GRAPHICS_PIPELINE_OPENGL_H
#define _GRAPHICS_PIPELINE_OPENGL_H

#include "graphics-pipeline.hpp"

#include <vector>

#include <GL/glew.h>

enum VaryingAttribType {
   ATTRIB_OBJECT_VARYING,
   ATTRIB_POINT_VARYING,
};

// TODO: Might be better to create a different struct for uniform attributes
struct VaryingAttribInfo {
   VaryingAttribType attribType;
   GLuint index;
   GLint size;
   GLenum type;
   // UniformType uniType;
   GLuint buffer; // For uniforms, this is the uniform location
   size_t fieldOffset;
   // GLfloat* data; // pointer to data source for uniform attributes
};

class GraphicsPipeline_OpenGL : public GraphicsPipeline {
   public:
      GraphicsPipeline_OpenGL(Viewport viewport);
      ~GraphicsPipeline_OpenGL();

      void addVaryingAttribute(VaryingAttribType attribType, GLint size, GLenum type, size_t fieldOffset);
      void createPipeline(string vertShaderFile, string fragShaderFile);

   private:
      GLuint shaderProgram;
      GLuint vao;
      unsigned int numPoints;

      vector<VaryingAttribInfo> varyingAttribs;

      GLuint loadShaderProgram(string vertShaderFile, string fragShaderFile);
      GLuint loadShader(GLenum type, string file);
};

#endif // _GRAPHICS_PIPELINE_OPENGL_H