#ifndef _GAME_GUI_H
#define _GAME_GUI_H

#include <string>
#include <vector>

// TODO: Remove the line below once the couts in the game-gui-* files are moved
#include <iostream>

#ifdef GAMEGUI_INCLUDE_VULKAN
   #include <vulkan/vulkan.h>
#endif

using namespace std;

enum EventType {
   UI_EVENT_QUIT,
   UI_EVENT_WINDOW,
   UI_EVENT_KEY,
   UI_EVENT_MOUSEBUTTONDOWN,
   UI_EVENT_MOUSEBUTTONUP,
   UI_EVENT_MOUSEMOTION
};

struct WindowEvent {
   EventType type;
};

struct KeyEvent {
   EventType type;
   unsigned int keycode;
};

struct MouseEvent {
   EventType type;
};

union UIEvent {
   EventType type;
   WindowEvent window;
   KeyEvent key;
   MouseEvent mouse;
};

/*
struct MouseEvent {
   int button;
   int action;
   int x;
   int y;
};
*/

class GameGui {
   public:
      virtual ~GameGui() {};

      virtual string& getError() = 0;

      virtual bool init() = 0;
      virtual void shutdown() = 0;

      virtual void* createWindow(const string& title, int width, int height, bool fullscreen) = 0;
      virtual void destroyWindow() = 0;

      virtual void processEvents() = 0;
      virtual int pollEvent(UIEvent* event) = 0;

      /*
      virtual void processEvents() = 0;

      virtual int pollMouseEvent(MouseEvent* event) = 0;

      virtual unsigned char getKeyEvent(unsigned int key) = 0;
      virtual bool isKeyPressed(unsigned int key) = 0;
      */

#ifdef GAMEGUI_INCLUDE_VULKAN
      virtual bool createVulkanSurface(VkInstance instance, VkSurfaceKHR* surface) = 0;
#endif

      virtual vector<const char*> getRequiredExtensions() = 0;
      virtual void getWindowSize(int* width, int* height) = 0;
};

#endif // _GAME_GUI_H
