import java.net.*;

public class PortalInterfaceThread extends Connection {
	private LostHavenServer main;
	private boolean accepted;

    public PortalInterfaceThread(Socket socket, LostHavenServer main) {
    	super(socket, "PortalInterfaceThread");
    	
    	this.main = main;
    	accepted = false;
    }
    
    protected void processMessage(MessageType type, String input) {
    	if(type != MessageType.Admin && !accepted) {
    		closeConnection();
    		return;
    	}
    	
    	switch(type) {
    	case Admin:
    		accepted = true;
    		if(main.running)
    			sendMessage(MessageType.Info, "started");
    		else
    			sendMessage(MessageType.Info, "stopped");
    		sendRegisteredPlayers();
    		break;
    	case StartServer:
    		main.start();
    		sendMessage(MessageType.Info, "started");
    		break;
    	case StopServer:
    		main.stop();
    		sendMessage(MessageType.Info, "stopped");
    		break;
    	}
    }
    
    private void sendRegisteredPlayers() {
    	String[] reg;
    	Player p;
    	String str;
    	
    	reg = (String[])main.orderedReg.toArray(new String[0]);
    	for(int x=0; x<main.orderedReg.size(); x++) {
    		p = main.registered.get(reg[x]);
    		
    		str = p.getId() + ";" + p.getName() + ";" + main.online.containsKey(p.getName());
    		sendMessage(MessageType.Registered, str);
    	}
    }
    
    protected void connectionStart() {
    	
    }
    
    protected void connectionSuccess() {
    	
    }
    
    protected void connectionFailure() {
    	
    }
    
    protected void connectionBreak() {
    	//record unexpected portal exit in the log
    }
    
    protected void peerDisconnect() {
    	//record regular portal exit in the log
    }
    
    protected void connectionEnd() {
    	
    }
}
