import java.net.*;
import java.util.*;

public class ServerThread extends Connection {
	private LostHavenServer main;
    private Player player;
    private Client client;

    public ServerThread(Socket socket, LostHavenServer main) {
    	super(socket, "ServerThread");
    	this.main = main;
    }
    
    protected void processMessage(MessageType type, String input) {
    	String user, pass;
    	Gender gender;
    	Job job;
    	String message;
    	String receiver = "";
    	String channel = "";

    	switch(type) {
    	case Chat:
    		if(input.indexOf("]") != -1 && (input.indexOf(">") == -1 || input.indexOf(">") > input.indexOf("]"))) {
    			channel = input.substring(0, input.indexOf("]"));
    			message = input.substring(input.indexOf("]")+1);
    		}else {
    			receiver = input.substring(0, input.indexOf(">"));
    			message = input.substring(input.indexOf(">")+1);
    		}

            if(receiver.equals("")) {
            	main.updateLog("chatlog.txt", main.dateString() + " [" + channel + "] " + player.getName() + "> " + message);

	            if(channel.equals("None")) {
	            	sendMessage(MessageType.Chat, player.getName() + "> " + message);
	            }else {
	            	Iterator<String> iter = main.online.keySet().iterator();
	            	String name;
	            	
	        		while(iter.hasNext())
	        		{
	        			name = iter.next();
	        			if(main.registered.get(name).getChannel().equals(channel)) {
	        				main.online.get(name).getOut().println(MessageType.Chat);
	        				main.online.get(name).getOut().println(player.getName() + "> " + message);
	        			}
	        		}
	            }
            }else {
            	if(!main.registered.containsKey(receiver)) {
            		sendMessage(MessageType.Chat, "Player " + receiver + " does not exist.");
            	}else if(!main.online.containsKey(receiver)) {
            		sendMessage(MessageType.Chat, "Player " + receiver + " is not online.");
            	}else if(receiver.equals(player.getName())) {
            		sendMessage(MessageType.Chat, "Why are you sending a message to yourself?");
            	}else {
            		main.online.get(receiver).getOut().println(MessageType.Chat);
            		main.online.get(receiver).getOut().println("Private message from " + player.getName() + "> " + message);
            		sendMessage(MessageType.Chat, "Private message to " + receiver + "> " + message);
            		
            		main.updateLog("chatlog.txt", main.dateString() + " Private message from " + player.getName() + " to " + receiver + "> " + message);
            	}
            }
    		break;
    	case Channel:
    		player.setChannel(input);
    		sendMessage(MessageType.Channel, "");
    		break;
    	case Login:
    		user = input.substring(0, input.indexOf(";"));
    		input = input.substring(input.indexOf(";")+1);
    		pass = input;

    		if(!main.registered.containsKey(user))
    			sendMessage(MessageType.Login, "No such player exists");
    		else if(!main.registered.get(user).getPass().equals(pass))
    			sendMessage(MessageType.Login, "Incorrect password");
    		else if(main.online.containsKey(user))
    			sendMessage(MessageType.Login, "This player is already logged on");
    		else {
    			player = main.registered.get(user);
    			client.setTimeLoggedOn(Calendar.getInstance());
    			main.updateLog("playerlog.txt", "Player " + user + " logged in on " + main.dateString());
    			sendLoadInfo();
    			main.addOnlineList(user, client);
    			main.sendAll(MessageType.PlayerJoined, "Player " + player.getName() + " logged on");
    		}
    		break;
    	case Create:
    		user = input.substring(0, input.indexOf(";"));
    		input = input.substring(input.indexOf(";")+1);
    		pass = input.substring(0, input.indexOf(";"));
    		input = input.substring(input.indexOf(";")+1);
    		gender = Gender.valueOf(input.substring(0, input.indexOf(";")));
    		input = input.substring(input.indexOf(";")+1);
    		job = Job.valueOf(input);
    		
    		if(main.registered.containsKey(user))
    			sendMessage(MessageType.Create, "Username already exists");
    		else {
    			player = new Player(main.orderedReg.size()+1, user, pass);
    			player.setGender(gender);
    			player.createJob(job);
    			main.addRegList(user, player);
    			main.updateLog("playerlog.txt", "Player " + user + " created on " + main.dateString());
	    		sendMessage(MessageType.Create, "Account created successfully");
	    		main.sendAll(MessageType.Registered, player.getId() + ";" + player.getName() + ";" + player.getGender()+ ";" + false);
    		}
    		break;
    	case Movement:
    		int y = Integer.valueOf(input.substring(0, input.indexOf(",")));
    		int x = Integer.valueOf(input.substring(input.indexOf(",")+1));
    		
    		player.setTarget(new Point(x, y));
    	}
    }
    
    private void sendRegisteredPlayers() {
    	String[] reg;
    	Player p;
    	String str;
    	
    	reg = (String[])main.orderedReg.toArray(new String[0]);
    	for(int x=0; x<main.orderedReg.size(); x++) {
    		p = main.registered.get(reg[x]);
    		
    		str = p.getId() + ";" + p.getName() + ";" + p.getGender() + ";" + main.online.containsKey(p.getName());
    		sendMessage(MessageType.Registered, str);
    	}
    }
    
    private void sendLoadInfo() {
    	sendMessage(MessageType.LoadStart, Integer.toString(main.orderedReg.size()+main.map.getLength()*main.map.getHeight()+3));
    	sendRegisteredPlayers();
    	sendMessage(MessageType.LoadMap, main.map.getLength()+"x"+main.map.getHeight());
    	
    	for(int x=0; x<main.map.getLength(); x++) {
    		for(int y=0; y<main.map.getHeight(); y++) {
    			sendMessage(MessageType.LoadMap, x+","+y+" "+main.map.getLoc(x, y).getLand().getType().toString()+" "+main.map.getLoc(x, y).getStruct().getType().toString());
    		}
    	}
    	
    	sendMessage(MessageType.LoadEnd, "");
    }
    
    protected void connectionStart() {
    	
    }
    
    protected void connectionSuccess() {
    	client = new Client(getOut());
    }
    
    protected void connectionFailure() {
    	
    }
    
    protected void connectionBreak() {
    	if(player != null && main.online.containsKey(player.getName())) {
			main.removeOnlineList(player.getName());
			main.updateLog("playerlog.txt", "Player " + player.getName() + " disconnected unexpectedly on " + main.dateString());
			main.sendAll(MessageType.PlayerLeft, "Player " + player.getName() + " disconnected unexpectedly");
		}
    }
    
    protected void peerDisconnect() {
    	if(player != null && main.online.containsKey(player.getName())) {
    		main.removeOnlineList(player.getName());
    		main.updateLog("playerlog.txt", "Player " + player.getName() + " logged off on " + main.dateString());
    		main.sendAll(MessageType.PlayerLeft, "Player " + player.getName() + " logged off");
    	}
    }
    
    protected void connectionEnd() {
    	
    }
}
