
public class Player implements Comparable<Player> {
	/*
Dim ID As Integer					added
Dim GameID As Integer				unnecessary	
Dim Name As String					added
Dim Password As String				added
Dim Online As Boolean				probably unnecessary
Dim State As Integer				not added yet
Dim currentChannel As Channel		added
Dim Chat As String					not added yet
Dim Job As Integer					added
Dim Level As Integer				added
Dim Inventory() As Item				not added yet
Dim ItemAmount As Integer			not added yet
Dim Spells() As Spell				not added yet
Dim Location As MapPoint			added
Dim TargetLocation As MapPoint		added
Dim TargetEnemy As Integer			not added yet
Dim TargetItem As Integer			not added yet
Dim Gender As Integer				added
Dim Speed As Integer				added
Dim Damage As String				added
Dim Cooldown As Integer				added
Dim LastAttacked As Integer			added
Dim ExtraPoints As Integer			added
Dim Strength As Integer				added
Dim Dexterity As Integer			added
Dim Constitution As Integer			added
Dim Charisma As Integer				added
Dim Wisdom As Integer				added
Dim Intelligence As Integer			added
Dim HitPoints As Integer			added
Dim MaxHitPoints As Integer			added
Dim ManaPoints As Integer			added
Dim MaxManaPoints As Integer		added
Dim Experience As Integer			added
Dim Gold As Integer					added
	*/
	private int id;
	private String name;
	private String pass;
	private Gender gender;
	private String channel;
	private Job job;
	private int level;
	private Point loc;
	private Point target;
	private int speed;
	private long lastMoved;
	private int attackSpeed;
	private int damage;
	private long lastAttacked;
	private int strength;
	private int dexterity;
	private int constitution;
	private int charisma;
	private int wisdom;
	private int intelligence;
	private int hitpoints;
	private int manapoints;
	private int maxHitpoints;
	private int maxManapoints;
	private int experience;
	private int gold;

	public Player() {
		id = 0;
		name = "";
		pass = "";
		gender = Gender.None;
		channel = "None";
		job = Job.None;
		loc = new Point(0, 0);
		target = new Point(0, 0);
	}

	public Player(int id, String name, String pass) {
		this.id = id;
		this.name = name;
		this.pass = pass;
		channel = "None";
		job = Job.None;
		loc = new Point(0, 0);
		target = new Point(0, 0);
	}
	
	public Player(int id, String name, String pass, Gender gender) {
		this.id = id;
		this.name = name;
		this.pass = pass;
		channel = "None";
		this.gender = gender;
		job = Job.None;
		loc = new Point(0, 0);
		target = new Point(0, 0);
	}
	
	public Player(int id, String name, String pass, Gender gender, Job job) {
		this.id = id;
		this.name = name;
		this.pass = pass;
		channel = "None";
		this.gender = gender;
		this.job = job;
		loc = new Point(0, 0);
		target = new Point(0, 0);
	}
	
	public void createJob(Job job) {
		this.job = job;
		
		switch(job) {
		case Fighter:
			strength = 12;
            dexterity = 10;
            constitution = 10;
            charisma = 10;
            wisdom = 10;
            intelligence = 10;
			break;
		case Ranger:
			strength = 10;
            dexterity = 12;
            constitution = 10;
            charisma = 10;
            wisdom = 10;
            intelligence = 10;
			break;
		case Barbarian:
			strength = 10;
            dexterity = 10;
            constitution = 12;
            charisma = 10;
            wisdom = 10;
            intelligence = 10;
			break;
		case Sorceror:
			strength = 10;
            dexterity = 10;
            constitution = 10;
            charisma = 12;
            wisdom = 10;
            intelligence = 10;
			break;
		case Druid:
			strength = 10;
            dexterity = 10;
            constitution = 10;
            charisma = 10;
            wisdom = 12;
            intelligence = 10;
			break;
		case Wizard:
			strength = 10;
            dexterity = 10;
            constitution = 10;
            charisma = 10;
            wisdom = 10;
            intelligence = 12;
			break;
		}
	}

	public int getAttackSpeed() {
		return attackSpeed;
	}

	public String getChannel() {
		return channel;
	}

	public int getCharisma() {
		return charisma;
	}

	public int getConstitution() {
		return constitution;
	}

	public int getDamage() {
		return damage;
	}

	public int getDexterity() {
		return dexterity;
	}

	public int getExperience() {
		return experience;
	}

	public Gender getGender() {
		return gender;
	}

	public int getGold() {
		return gold;
	}

	public int getHitpoints() {
		return hitpoints;
	}

	public int getId() {
		return id;
	}

	public int getIntelligence() {
		return intelligence;
	}

	public Job getJob() {
		return job;
	}

	public long getLastAttacked() {
		return lastAttacked;
	}

	public long getLastMoved() {
		return lastMoved;
	}

	public int getLevel() {
		return level;
	}

	public Point getLoc() {
		return loc;
	}

	public int getManapoints() {
		return manapoints;
	}

	public int getMaxHitpoints() {
		return maxHitpoints;
	}

	public int getMaxManapoints() {
		return maxManapoints;
	}

	public String getName() {
		return name;
	}

	public String getPass() {
		return pass;
	}

	public int getSpeed() {
		return speed;
	}

	public int getStrength() {
		return strength;
	}

	public Point getTarget() {
		return target;
	}

	public int getWisdom() {
		return wisdom;
	}

	public void setAttackSpeed(int attackSpeed) {
		this.attackSpeed = attackSpeed;
	}

	public void setChannel(String channel) {
		this.channel = channel;
	}

	public void setCharisma(int charisma) {
		this.charisma = charisma;
	}

	public void setConstitution(int constitution) {
		this.constitution = constitution;
	}

	public void setDamage(int damage) {
		this.damage = damage;
	}

	public void setDexterity(int dexterity) {
		this.dexterity = dexterity;
	}

	public void setExperience(int experience) {
		this.experience = experience;
	}

	public void setGender(Gender gender) {
		this.gender = gender;
	}

	public void setGold(int gold) {
		this.gold = gold;
	}

	public void setHitpoints(int hitpoints) {
		this.hitpoints = hitpoints;
	}

	public void setId(int id) {
		this.id = id;
	}

	public void setIntelligence(int intelligence) {
		this.intelligence = intelligence;
	}

	public void setJob(Job job) {
		this.job = job;
	}

	public void setLastAttacked(long lastAttacked) {
		this.lastAttacked = lastAttacked;
	}

	public void setLastMoved(long lastMoved) {
		this.lastMoved = lastMoved;
	}

	public void setLevel(int level) {
		this.level = level;
	}

	public void setLoc(Point loc) {
		this.loc = loc;
	}

	public void setManapoints(int manapoints) {
		this.manapoints = manapoints;
	}

	public void setMaxHitpoints(int maxHitpoints) {
		this.maxHitpoints = maxHitpoints;
	}

	public void setMaxManapoints(int maxManapoints) {
		this.maxManapoints = maxManapoints;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setPass(String pass) {
		this.pass = pass;
	}

	public void setSpeed(int speed) {
		this.speed = speed;
	}

	public void setStrength(int strength) {
		this.strength = strength;
	}

	public void setTarget(Point target) {
		this.target = target;
	}

	public void setWisdom(int wisdom) {
		this.wisdom = wisdom;
	}

	public String toString() {
		return name;
	}
	
	public boolean equals(Object p) {
		return name.trim().equals(((Player)p).name.trim());
	}
	
	public int compareTo(Player p) {
		return id - p.id;
	}
}
